/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.util.Args;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class CommentedFileReader
extends BufferedReader {
    private static final boolean dbg = false;

    public CommentedFileReader(Reader reader) throws IOException {
        super(reader);
    }

    public CommentedFileReader(File file) throws IOException {
        super(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
    }

    @Override
    public String readLine() throws IOException {
        String string = super.readLine();
        while (this.shouldSkip(string)) {
            string = super.readLine();
        }
        return string;
    }

    protected boolean shouldSkip(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        return string2.length() == 0 || string2.startsWith("#") || string2.startsWith("//");
    }

    public static void main(String[] stringArray) throws IOException {
        Args args = new Args(stringArray);
        String string = args.getRequired("file");
        CommentedFileReader commentedFileReader = new CommentedFileReader(new File(string));
        String string2 = null;
        while ((string2 = commentedFileReader.readLine()) != null) {
            System.out.println(string2);
        }
    }
}

