/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.HAlign;
import fc.util.StringUtil;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public final class HexOutputStream
extends FilterOutputStream {
    static final boolean dbg = false;
    final PrintStream out;
    final String sp1 = " ";
    final String sp2 = "  ";
    final String sp3 = "   ";
    final String nl = IOUtil.LINE_SEP;
    boolean showHex = true;
    int baseValue;
    int baseMaxWidth = 2;
    boolean autoflush = true;
    boolean linenumbers = true;
    int width;
    byte[] tempBuf;
    int tempBufPtr;
    int tempBufLimit;
    static final char[] hex = "0123456789abcdef".toCharArray();

    public HexOutputStream(OutputStream outputStream) {
        this(outputStream, 16);
    }

    public HexOutputStream(OutputStream outputStream, int n) {
        super(null);
        Argcheck.notnull(outputStream);
        Argcheck.istrue(n > 0, "the specified width must be greater than 0");
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.width = n;
        this.tempBuf = new byte[n];
        this.tempBufLimit = n - 1;
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(int n) {
        this.tempBuf[this.tempBufPtr++] = (byte)n;
        if (this.tempBufPtr == this.tempBufLimit) {
            this.write(this.tempBuf, 0, this.tempBufLimit);
            this.tempBufPtr = 0;
        }
    }

    @Override
    public void write(byte[] byArray) {
        if (byArray == null) {
            this.out.println("null");
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this.out.println("null");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        int n3 = n2 - n;
        int n4 = n + n2;
        int n5 = n3 / this.width;
        int n6 = Integer.toString(n3).length();
        int n7 = 0;
        for (int i = n; i < n3; i += this.width) {
            int n8;
            if (this.linenumbers && n5 > 0) {
                stringBuffer.append(StringUtil.fixedWidth(String.valueOf(n7), n6, HAlign.RIGHT, '0'));
                n7 += this.width;
            }
            stringBuffer.append("| ");
            int n9 = 0;
            int n10 = i + this.width;
            for (n8 = i; n8 < n10 && n8 < n4; ++n8) {
                n9 = byArray[n8] & 0xFF;
                if (this.showHex) {
                    stringBuffer.append(HexOutputStream.toHex(n9));
                } else {
                    stringBuffer.append(StringUtil.fixedWidth(Integer.toString(n9, this.baseValue), this.baseMaxWidth, HAlign.RIGHT, '0'));
                }
                stringBuffer.append(" ");
            }
            int n11 = 0;
            if (n8 == n4) {
                n11 = i + this.width - n8;
                stringBuffer.append(StringUtil.repeat(' ', (this.baseMaxWidth + 1) * n11));
            }
            stringBuffer.append("| ");
            for (n8 = i; n8 < n10 && n8 < n4; ++n8) {
                n9 = byArray[n8] & 0xFF;
                if (n9 < 32 || n9 >= 127) {
                    stringBuffer.append('.');
                    continue;
                }
                stringBuffer.append((char)n9);
            }
            if (n8 == n4) {
                stringBuffer.append(StringUtil.repeat(" ", n11));
            }
            stringBuffer.append(" |");
            stringBuffer.append(this.nl);
        }
        this.out.print(stringBuffer.toString());
        if (this.autoflush) {
            this.out.flush();
        }
    }

    public void setAutoFlush(boolean bl) {
        this.autoflush = bl;
    }

    public void showLineNumbers(boolean bl) {
        this.linenumbers = bl;
    }

    public void setBase(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("The base must be between 2 and 36 (both inclusive)");
        }
        this.baseValue = n;
        this.baseMaxWidth = this.calcBaseMaxWidth(n);
        if (this.baseValue != 16) {
            this.showHex = false;
        }
    }

    int calcBaseMaxWidth(int n) {
        int n2 = 0;
        int n3 = 255;
        do {
            ++n2;
        } while ((n3 /= n) > 0);
        return n2;
    }

    static final char[] toHex(int n) {
        char[] cArray = new char[]{n < 16 ? (char)'0' : hex[n >> 4 & 0xF], hex[n & 0xF]};
        return cArray;
    }

    public static final String toHex(byte[] byArray) {
        Argcheck.notnull(byArray, "buf was null");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuilder.append(HexOutputStream.toHex(n));
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        int n = -1;
        HexOutputStream hexOutputStream = null;
        Args args = new Args(stringArray);
        args.setUsage("Usage: java HexOutputStream <options>\noptions:\n\t-file filename or -data string\r\n\t-cols num (optional number of display columns)\n\t-base num (optional base 2..36 to show bytes in)");
        if (args.getFlagCount() == 0) {
            args.showError();
        }
        byte[] byArray = null;
        if (args.flagExists("file")) {
            String string = args.get("file");
            byArray = IOUtil.fileToByteArray(string);
        } else {
            String string = args.getRequired("data");
            if (string != null) {
                byArray = string.getBytes();
            }
        }
        if (args.flagExists("cols")) {
            n = Integer.parseInt(args.get("cols"));
        }
        hexOutputStream = n >= 0 ? new HexOutputStream(System.out, n) : new HexOutputStream(System.out);
        if (args.flagExists("base")) {
            hexOutputStream.setBase(Byte.parseByte(args.get("base")));
        }
        long l = -1L;
        hexOutputStream.write(byArray);
        hexOutputStream.close();
    }
}

