/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.io.IOUtil;
import fc.io.LogLevel;
import fc.io.SystemLog;
import fc.util.Argcheck;
import fc.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class Log {
    public static final LogLevel OFF = new LogLevel("OFF", 0);
    public static final LogLevel ERROR = new LogLevel("ERROR", 1);
    public static final LogLevel WARN = new LogLevel("WARN", 2);
    public static final LogLevel INFO = new LogLevel("INFO", 3);
    public static final LogLevel DEBUG = new LogLevel("DEBUG", 4);
    public static LogLevel DEFAULT_LEVEL = INFO;
    protected static final byte[] linesepbytes = System.getProperty("line.separator").getBytes();
    protected static SystemLog defaultlog;
    protected static final Map logs;
    protected String name;
    protected LogLevel currentLevel;
    protected long startTime;
    protected String startTimeString;
    protected boolean printLevelName = true;
    protected boolean printTimestamp = false;
    protected boolean timestampIsRelative = false;
    protected LogLevel printMethodInfoAtLevel = DEBUG;
    protected final SimpleDateFormat df = new SimpleDateFormat("MMM dd H:m:s z");
    protected final NumberFormat nf = NumberFormat.getNumberInstance();
    protected Date date = new Date();
    protected long last_time = this.date.getTime();
    protected String timestr = this.df.format(this.date);

    protected Log(String string, LogLevel logLevel) {
        assert (string != null) : "name was null";
        assert (logLevel != null) : "level was null";
        this.name = string;
        this.currentLevel = logLevel;
        this.startTime = System.currentTimeMillis();
        this.startTimeString = new Date(this.startTime).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log get(String string) {
        Log log = (Log)logs.get(string);
        if (log != null) {
            return log;
        }
        Map map = logs;
        synchronized (map) {
            log = new SystemLog(string);
            logs.put(string, log);
        }
        return log;
    }

    public static Log getLog(String string) {
        return Log.get(string);
    }

    public static final Log get(Class clazz) {
        Argcheck.notnull(clazz, "class parameter was null");
        Package package_ = clazz.getPackage();
        String string = package_ == null ? "default_pkg" : package_.toString();
        return Log.get(string);
    }

    public static final Log get(Object object) {
        Argcheck.notnull(object, "class parameter was null");
        return Log.get(object.getClass().getPackage().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemLog getDefault() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (defaultlog == null) {
                defaultlog = new SystemLog("_defaultlog", System.out, SystemLog.INFO);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultlog;
        }
    }

    public Iterator getLevelNames() {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Object var3_3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getType().isAssignableFrom(LogLevel.class)) continue;
            arrayList.add(field.getName());
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addLog(Log log) {
        Map map = logs;
        synchronized (map) {
            if (logs.containsKey(log.name)) {
                throw new IllegalArgumentException("Log already exists: " + log);
            }
            logs.put(log.name, log);
        }
    }

    public static void closeLog(String string) {
        if (logs.containsKey(string)) {
            Log log = (Log)logs.get(string);
            log.close();
            logs.remove(string);
        }
    }

    public final String getDebugContext(LogLevel logLevel, int n) {
        if (logLevel.intval < this.printMethodInfoAtLevel.intval) {
            return "";
        }
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        if (n >= stackTraceElementArray.length) {
            throw new IllegalArgumentException("framenum [" + n + "] too large. Max number of record in stack = " + (stackTraceElementArray.length - 1));
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[n];
        String string = stackTraceElement.getFileName();
        int n2 = stackTraceElement.getLineNumber();
        String string2 = stackTraceElement.getMethodName();
        String string3 = Thread.currentThread().getName();
        return string2 + "() [" + string + ":" + n2 + "/thread:" + string3 + "]";
    }

    public void printLevelName(boolean bl) {
        this.printLevelName = bl;
    }

    public void printTimestamp(boolean bl) {
        this.printTimestamp = bl;
    }

    public void printRelativeTimestamp(boolean bl) {
        this.timestampIsRelative = bl;
        this.last_time = new Date().getTime();
    }

    public void printMethodInfoAtLevel(LogLevel logLevel) {
        this.printMethodInfoAtLevel = logLevel;
    }

    protected final String getTS() {
        this.date = new Date();
        long l = this.date.getTime();
        if (this.timestampIsRelative) {
            return this.nf.format((l - this.last_time) / 1000L);
        }
        if (l - this.last_time >= 1000L) {
            this.last_time = l;
            this.timestr = this.df.format(this.date);
        }
        return this.timestr;
    }

    public void setLevel(LogLevel logLevel) {
        assert (logLevel != null) : "specified level was null";
        this.currentLevel = logLevel;
    }

    public void setLevel(String string) {
        if (string == null) {
            this.warn("specified levelname was null, log level will not be changed");
            return;
        }
        try {
            Field field = Log.stringToLevel(string);
            if (field == null) {
                this.warn("Specified level", string, "is not valid/could not be resolved");
                return;
            }
            Method method = Log.class.getMethod("setLevel", LogLevel.class);
            method.invoke((Object)this, field.get(this));
            this.info("New log level for log=[", this.name, "] set to: ", this.currentLevel);
        }
        catch (Exception exception) {
            this.warn(exception);
        }
    }

    protected static Field stringToLevel(String string) {
        Field[] fieldArray = Log.class.getDeclaredFields();
        Field field = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field2 = fieldArray[i];
            if (!field2.getType().isAssignableFrom(LogLevel.class) || !field2.getName().equalsIgnoreCase(string)) continue;
            field = field2;
        }
        return field;
    }

    public static void setLevelForAll(String string, LogLevel logLevel) {
        for (String string2 : logs.keySet()) {
            if (!string2.contains(string2)) continue;
            ((Log)logs.get(string2)).setLevel(logLevel);
        }
    }

    public static void setDefaultLevel(LogLevel logLevel) {
        DEFAULT_LEVEL = logLevel;
    }

    public static void setDefaultLevel(String string) {
        if (string == null) {
            new Exception("the specified level was null, log level will not be changed").printStackTrace();
            return;
        }
        try {
            Field field = Log.stringToLevel(string);
            if (field == null) {
                return;
            }
            Method method = Log.class.getMethod("setDefaultLevel", LogLevel.class);
            method.invoke(null, field.get(null));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean canLog(LogLevel logLevel) {
        assert (logLevel != null) : "specified level was null";
        return logLevel.intval <= this.currentLevel.intval;
    }

    public String getName() {
        return this.name;
    }

    public LogLevel getLevel() {
        return this.currentLevel;
    }

    public void logSystemInfo() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(IOUtil.LINE_SEP);
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string).append("=");
            if (string.equals("line.separator")) {
                stringBuffer.append(StringUtil.viewableAscii(properties.getProperty(string)));
                continue;
            }
            stringBuffer.append(properties.getProperty(string));
        }
        stringBuffer.append(IOUtil.LINE_SEP);
        this.info(stringBuffer.toString());
    }

    public String toString() {
        return this.name + " [" + this.getClass().getName() + "/currentlevel:" + this.currentLevel.desc + "/started:" + this.startTimeString + "]";
    }

    public final void error(Object object) {
        this.doLog(ERROR, object);
    }

    public final void error(Object object, Object object2) {
        this.doLog(ERROR, object, object2);
    }

    public final void error(Object object, Object object2, Object object3) {
        this.doLog(ERROR, object, object2, object3);
    }

    public final void error(Object object, Object object2, Object object3, Object object4) {
        this.doLog(ERROR, object, object2, object3, object4);
    }

    public final void error(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.doLog(ERROR, object, object2, object3, object4, object5);
    }

    public final void error(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.doLog(ERROR, object, object2, object3, object4, object5, object6);
    }

    public final void error(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.doLog(ERROR, object, object2, object3, object4, object5, object6, object7);
    }

    public final void error(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        this.doLog(ERROR, object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    public final void warn(Object object) {
        this.doLog(WARN, object);
    }

    public final void warn(Object object, Object object2) {
        this.doLog(WARN, object, object2);
    }

    public final void warn(Object object, Object object2, Object object3) {
        this.doLog(WARN, object, object2, object3);
    }

    public final void warn(Object object, Object object2, Object object3, Object object4) {
        this.doLog(WARN, object, object2, object3, object4);
    }

    public final void warn(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.doLog(WARN, object, object2, object3, object4, object5);
    }

    public final void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.doLog(WARN, object, object2, object3, object4, object5, object6);
    }

    public final void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.doLog(WARN, object, object2, object3, object4, object5, object6, object7);
    }

    public final void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        this.doLog(WARN, object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    public final void info(Object object) {
        this.doLog(INFO, object);
    }

    public final void info(Object object, Object object2) {
        this.doLog(INFO, object, object2);
    }

    public final void info(Object object, Object object2, Object object3) {
        this.doLog(INFO, object, object2, object3);
    }

    public final void info(Object object, Object object2, Object object3, Object object4) {
        this.doLog(INFO, object, object2, object3, object4);
    }

    public final void info(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.doLog(INFO, object, object2, object3, object4, object5);
    }

    public final void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.doLog(INFO, object, object2, object3, object4, object5, object6);
    }

    public final void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.doLog(INFO, object, object2, object3, object4, object5, object6, object7);
    }

    public final void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        this.doLog(INFO, object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    public final void debug(Object object) {
        this.doLog(DEBUG, object);
    }

    public final void debug(Object object, Object object2) {
        this.doLog(DEBUG, object, object2);
    }

    public final void debug(Object object, Object object2, Object object3) {
        this.doLog(DEBUG, object, object2, object3);
    }

    public final void debug(Object object, Object object2, Object object3, Object object4) {
        this.doLog(DEBUG, object, object2, object3, object4);
    }

    public final void debug(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.doLog(DEBUG, object, object2, object3, object4, object5);
    }

    public final void debug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6);
    }

    public final void debug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6, object7);
    }

    public final void debug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    public final void bug(Object object) {
        this.doLog(DEBUG, object);
    }

    public final void bug(Object object, Object object2) {
        this.doLog(DEBUG, object, object2);
    }

    public final void bug(Object object, Object object2, Object object3) {
        this.doLog(DEBUG, object, object2, object3);
    }

    public final void bug(Object object, Object object2, Object object3, Object object4) {
        this.doLog(DEBUG, object, object2, object3, object4);
    }

    public final void bug(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.doLog(DEBUG, object, object2, object3, object4, object5);
    }

    public final void bug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6);
    }

    public final void bug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6, object7);
    }

    public final void bug(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        this.doLog(DEBUG, object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    final void doLog(LogLevel logLevel, Object object) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3, Object object4) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3, object4);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3, object4, object5);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3, object4, object5, object6);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3, object4, object5, object6, object7);
    }

    final void doLog(LogLevel logLevel, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object ... objectArray) {
        if (logLevel.intval > this.currentLevel.intval) {
            return;
        }
        this.log(logLevel, this.getDebugContext(logLevel, 3), object, object2, object3, object4, object5, object6, object7, objectArray);
    }

    public abstract void close();

    public abstract void log(LogLevel var1, Object var2);

    public abstract void log(LogLevel var1, Object var2, Object var3);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5, Object var6);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);

    public abstract void log(LogLevel var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object ... var10);

    static {
        logs = new Hashtable();
        Runtime.getRuntime().addShutdownHook(new Thread("fc.io.Log.Shutdown"){

            @Override
            public void run() {
                System.out.println("JVM shutdown: fc.io.Log - closing all logs...");
                Iterator iterator = logs.values().iterator();
                while (iterator.hasNext()) {
                    ((Log)iterator.next()).close();
                }
                System.out.println();
            }
        });
    }
}

