/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.util.HAlign;
import fc.util.StringUtil;
import fc.util.ToString;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TablePrinter {
    private static final boolean dbg = false;
    private static final Object Extra_Content_Marker = new Object();
    String linesep = IOUtil.LINE_SEP;
    PrintConfig config;
    PrintWriter out;
    int columncount;
    String rowborder;
    int cellwidth;
    String spacing_str;
    String padding_str;
    boolean usingSpacing;
    boolean printingHeader;
    int current_linenum;
    int current_cellnum;
    String[] wrappedcells;
    int wrapcells_left;
    int[] largest_width;
    List autoFitTableData = new ArrayList();
    int currentAutoFitRow;
    int currentAutoFitCell;
    private final Pattern newlines = Pattern.compile("\\r|\\n|\\r\\n");

    public TablePrinter(int n, PrintStream printStream, PrintConfig printConfig) {
        this(n, new PrintWriter(printStream), printConfig);
    }

    public TablePrinter(int n, PrintWriter printWriter, PrintConfig printConfig) {
        Argcheck.notnull(printConfig, "config was null");
        Argcheck.notnull(printWriter, "printwriter/stream was null");
        this.columncount = n;
        this.out = printWriter;
        this.config = printConfig;
        this.cellwidth = printConfig.cellwidth;
        this.padding_str = StringUtil.repeatToWidth(printConfig.cellpadding_glyph, printConfig.cellpadding);
        this.spacing_str = StringUtil.repeatToWidth(printConfig.cellspacing_glyph, printConfig.cellspacing);
        this.usingSpacing = printConfig.cellspacing > 0;
        this.printingHeader = false;
        this.wrappedcells = new String[this.columncount];
        this.initRowBorder();
    }

    public void startTable() {
        if (this.config.autoFit) {
            this.startTableAutoFit();
            return;
        }
        if (this.config.header != null) {
            this.printHeader();
        }
    }

    public void endTable() {
        if (this.config.autoFit) {
            this.endTableAutoFit();
            return;
        }
        if (!this.usingSpacing) {
            this.printRowBorder();
        }
        if (this.usingSpacing) {
            this.printVerticalSpacing();
        }
        this.out.flush();
    }

    public void startRow() {
        if (this.config.autoFit) {
            this.startRowAutoFit();
            return;
        }
        this.current_cellnum = 0;
        if (!this.printingHeader && this.rowFinished()) {
            ++this.current_linenum;
        }
        if (this.rowFinished()) {
            if (this.usingSpacing) {
                this.printVerticalSpacing();
            }
            this.printRowBorder();
        }
    }

    void endRowCommon() {
        if (!this.usingSpacing) {
            if (this.config.printborder) {
                this.out.print(this.config.cellborder_v);
            }
        } else {
            this.out.print(this.spacing_str);
        }
        this.out.print(this.linesep);
    }

    public void endRow() {
        if (this.config.autoFit) {
            this.endRowAutoFit();
            return;
        }
        this.endRowCommon();
        if (this.config.cellwrap) {
            while (!this.rowFinished()) {
                this.startRow();
                for (int i = 0; i < this.columncount; ++i) {
                    this.printCell(this.wrappedcells[i]);
                }
                this.endRowCommon();
            }
        }
        if (this.usingSpacing) {
            this.printRowBorder();
        }
        if (!this.printingHeader && this.repeatHeader()) {
            this.printHeader();
        }
    }

    boolean repeatHeader() {
        int n = this.config.pageSize;
        if (n <= 0 || !this.config.headerEveryPage) {
            return false;
        }
        if (this.current_linenum == 0) {
            return false;
        }
        return this.current_linenum % n == 0;
    }

    public void printCell(String string) {
        if (this.current_cellnum == this.columncount) {
            throw new IllegalArgumentException("Cannot add more cells than number of columns in this table. (max columns=" + this.columncount + ")");
        }
        string = this.removeEmbeddedSpaces(string);
        if (this.config.autoFit) {
            this.printCellAutoFit(string);
            return;
        }
        if (this.usingSpacing) {
            this.out.print(this.spacing_str);
        }
        if (this.config.printborder) {
            this.out.print(this.config.cellborder_v);
        }
        this.printCellContent(string);
        if (this.usingSpacing && this.config.printborder) {
            this.out.print(this.config.cellborder_v);
        }
        ++this.current_cellnum;
    }

    public String toString() {
        return "TablePrinter. Config = " + this.config;
    }

    void printCellContent(String string) {
        int n = this.config.getCellWidthForColumn(this.current_cellnum);
        int n2 = string == null ? 0 : string.length();
        String string2 = StringUtil.fixedWidth(string, n, this.config.align);
        this.out.print(this.padding_str);
        this.out.print(string2);
        this.out.print(this.padding_str);
        if (this.config.cellwrap) {
            if (n2 > n) {
                if (this.wrappedcells[this.current_cellnum] == null) {
                    ++this.wrapcells_left;
                }
                this.wrappedcells[this.current_cellnum] = string.substring(n, n2);
            } else {
                if (this.wrappedcells[this.current_cellnum] != null) {
                    --this.wrapcells_left;
                }
                this.wrappedcells[this.current_cellnum] = null;
            }
        }
    }

    boolean rowFinished() {
        return this.wrapcells_left == 0;
    }

    void printHeader() {
        if (this.config.header == null) {
            return;
        }
        this.printingHeader = true;
        this.startRow();
        for (int i = 0; i < this.config.header.length; ++i) {
            this.printCell(this.config.header[i]);
        }
        this.endRow();
        this.printingHeader = false;
    }

    void printRowBorder() {
        if (!this.config.printborder) {
            return;
        }
        this.out.print(this.rowborder);
    }

    private void initRowBorder() {
        int n = this.cellwidth + 2 * this.config.cellpadding;
        if (!this.config.printborder) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.columncount * (1 + n + this.config.cellspacing));
        for (int i = 0; i < this.columncount; ++i) {
            if (this.usingSpacing) {
                stringBuffer.append(this.spacing_str);
            }
            stringBuffer.append(this.config.cellcorner);
            int n2 = this.config.getCellWidthForColumn(i) + 2 * this.config.cellpadding;
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(this.config.cellborder_h);
            }
            if (!this.usingSpacing) continue;
            stringBuffer.append(this.config.cellcorner);
        }
        if (!this.usingSpacing) {
            stringBuffer.append(this.config.cellcorner);
        }
        stringBuffer.append(this.linesep);
        this.rowborder = stringBuffer.toString();
    }

    void printVerticalSpacing() {
        for (int i = 1; i < this.config.cellspacing; ++i) {
            this.out.print(this.linesep);
        }
    }

    void startTableAutoFit() {
        this.largest_width = new int[this.columncount];
    }

    void endTableAutoFit() {
        int n = this.autoFitTableData.size();
        if (n == 0) {
            return;
        }
        this.config.setAutoFit(false);
        for (int i = 0; i < this.largest_width.length; ++i) {
            this.config.setCellWidthForColumn(i, this.largest_width[i]);
        }
        TablePrinter tablePrinter = this;
        tablePrinter.initRowBorder();
        tablePrinter.startTable();
        for (int i = 0; i < n; ++i) {
            tablePrinter.startRow();
            for (int j = 0; j < this.columncount; ++j) {
                tablePrinter.printCell(((String[])this.autoFitTableData.get(i))[j]);
            }
            tablePrinter.endRow();
        }
        tablePrinter.endTable();
    }

    void startRowAutoFit() {
        this.currentAutoFitCell = 0;
        this.autoFitTableData.add(this.currentAutoFitRow, new String[this.columncount]);
    }

    void endRowAutoFit() {
        ++this.currentAutoFitRow;
    }

    void printCellAutoFit(String string) {
        int n;
        int n2 = n = string != null ? string.length() : "null".length();
        if (this.largest_width[this.currentAutoFitCell] < n) {
            this.largest_width[this.currentAutoFitCell] = n;
        }
        String[] stringArray = (String[])this.autoFitTableData.get(this.currentAutoFitRow);
        stringArray[this.currentAutoFitCell++] = string;
    }

    String removeEmbeddedSpaces(String string) {
        if (string != null) {
            string = this.newlines.matcher(string).replaceAll(" ");
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("Table with borders and *NO* wrapping, (truncated to fixed cell width)");
        PrintConfig printConfig = new PrintConfig();
        printConfig.setCellWrap(false);
        TablePrinter.printTest(printConfig, null);
        System.out.println("Table with borders and autofit");
        printConfig = new PrintConfig();
        printConfig.setAutoFit(true);
        TablePrinter.printTest(printConfig, null);
        System.out.println("Table with borders and wrapping");
        printConfig = new PrintConfig();
        TablePrinter.printTest(printConfig, null);
        System.out.println("");
        System.out.println("Table with borders and padding & spacing");
        printConfig = new PrintConfig();
        printConfig.setAutoFit(true);
        printConfig.setCellSpacing(2);
        printConfig.setCellPadding(1);
        printConfig.setCellWidth(5);
        TablePrinter.printTest(printConfig, null);
        System.out.println("");
        System.out.println("Table with borders and padding & spacing and AUTOFIT");
        printConfig = new PrintConfig();
        printConfig.setCellSpacing(2);
        printConfig.setCellPadding(1);
        printConfig.setCellWidth(5);
        TablePrinter.printTest(printConfig, null);
        System.out.println("");
        System.out.println("Table with borders, spacing=2 page size = 2 lines and headers = true");
        printConfig = new PrintConfig();
        printConfig.setCellSpacing(2);
        printConfig.setCellWidth(5);
        printConfig.setPageSize(2);
        printConfig.headerEveryPage(true);
        TablePrinter.printTest(printConfig, new String[]{"Header", "A", "helloworld", "d", "End Header"});
        System.out.println("");
        System.out.println("Table with borders, no padding and default alignment of CENTER");
        printConfig = new PrintConfig();
        printConfig.setCellSpacing(0);
        printConfig.setCellPadding(0);
        printConfig.setCellWidth(15);
        printConfig.setAlign(HAlign.CENTER);
        TablePrinter.printTest(printConfig, null);
        System.out.println("");
        System.out.println("Table with no borders and padding & spacing");
        printConfig = new PrintConfig();
        printConfig.setPrintBorders(false);
        printConfig.setCellWidth(5);
        printConfig.setCellSpacing(2);
        printConfig.setCellPadding(3);
        TablePrinter.printTest(printConfig, null);
    }

    static void printTest(PrintConfig printConfig, String[] stringArray) {
        TablePrinter tablePrinter = new TablePrinter(5, System.out, printConfig);
        if (stringArray != null) {
            printConfig.setHeader(stringArray);
        }
        tablePrinter.startTable();
        tablePrinter.startRow();
        tablePrinter.printCell("abcdef");
        tablePrinter.printCell("4324");
        tablePrinter.printCell("Q");
        tablePrinter.printCell("");
        tablePrinter.printCell("abc");
        tablePrinter.endRow();
        tablePrinter.startRow();
        tablePrinter.printCell("row2: abc");
        tablePrinter.printCell("the quick brown \n-fox jumps over the lazy dog");
        tablePrinter.printCell("hello");
        tablePrinter.printCell("world");
        tablePrinter.printCell(null);
        tablePrinter.endRow();
        tablePrinter.startRow();
        tablePrinter.printCell("row3");
        tablePrinter.printCell("a");
        tablePrinter.printCell(null);
        tablePrinter.printCell(null);
        tablePrinter.printCell(null);
        tablePrinter.endRow();
        tablePrinter.endTable();
        System.out.println("TablePrinter.toString()=" + tablePrinter);
        System.out.println("");
    }

    public static class PrintConfig {
        static final ToString.Style style = new ToString.Style();
        private int cellwidth = 20;
        private Map cellwidthMap = new HashMap();
        private String cellcorner = "+";
        private String cellborder_h = "-";
        private String cellborder_v = "|";
        private String cellpadding_glyph = " ";
        private String cellspacing_glyph = " ";
        private boolean cellwrap = true;
        private boolean autoFit = false;
        private boolean printborder = true;
        private int cellspacing = 0;
        private int cellpadding = 0;
        private HAlign align = HAlign.LEFT;
        private int pageSize = -1;
        private boolean headerEveryPage = true;
        private String[] header;

        public void setHeader(String[] stringArray) {
            this.header = stringArray;
        }

        public String[] getHeader() {
            return this.header;
        }

        public PrintConfig setPageSize(int n) {
            this.pageSize = n;
            return this;
        }

        public PrintConfig headerEveryPage(boolean bl) {
            this.headerEveryPage = bl;
            return this;
        }

        public PrintConfig setAlign(HAlign hAlign) {
            this.align = hAlign;
            return this;
        }

        public PrintConfig setCellCorner(String string) {
            this.cellcorner = string;
            return this;
        }

        public PrintConfig setCellBorderHorizontal(String string) {
            this.cellborder_h = string;
            return this;
        }

        public PrintConfig setCellBorderVertical(String string) {
            this.cellborder_v = string;
            return this;
        }

        public PrintConfig setCellPaddingGlyph(String string) {
            this.cellpadding_glyph = string;
            return this;
        }

        public PrintConfig setCellSpacingGlyph(String string) {
            this.cellspacing_glyph = string;
            return this;
        }

        public PrintConfig setCellWidth(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("cell width must be greater than zero");
            }
            this.cellwidth = n;
            return this;
        }

        public PrintConfig setCellWidthForColumn(int n, int n2) {
            this.cellwidthMap.put(new Integer(n), new Integer(n2));
            return this;
        }

        int getCellWidthForColumn(int n) {
            Object v = this.cellwidthMap.get(new Integer(n));
            if (v != null) {
                return (Integer)v;
            }
            return this.cellwidth;
        }

        public PrintConfig setCellWrap(boolean bl) {
            this.cellwrap = bl;
            return this;
        }

        public PrintConfig setAutoFit(boolean bl) {
            this.autoFit = bl;
            if (bl) {
                this.cellwrap = false;
            }
            return this;
        }

        public PrintConfig setPrintBorders(boolean bl) {
            this.printborder = bl;
            return this;
        }

        public PrintConfig setCellSpacing(int n) {
            this.cellspacing = n;
            return this;
        }

        public PrintConfig setCellPadding(int n) {
            this.cellpadding = n;
            return this;
        }

        public String toString() {
            return new ToString((Object)this, style).reflect().render();
        }

        static {
            PrintConfig.style.reflectVisibleLevel = ToString.Style.VisibleLevel.PRIVATE;
        }
    }
}

