/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.util.Argcheck;
import fc.util.Args;

public final class DBName {
    public static final DBName mysql = new DBName("mysql");
    public static final DBName postgres = new DBName("postgresql");
    public static final DBName oracle = new DBName("oracle");
    private String name;

    private DBName(String string) {
        this.name = string;
    }

    public static DBName fromDriver(String string) {
        string = string.toLowerCase();
        Argcheck.notnull(string, "the specified driver_name was null");
        if (string.indexOf(DBName.mysql.name.toLowerCase()) >= 0) {
            return mysql;
        }
        if (string.indexOf(DBName.postgres.name.toLowerCase()) >= 0) {
            return postgres;
        }
        if (string.indexOf(DBName.oracle.name.toLowerCase()) >= 0) {
            return oracle;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static void main(String[] stringArray) {
        String string;
        Args args = new Args(stringArray);
        args.setUsage("java fc.jdbc.DBName -fromDriver driver-name ");
        if (!args.flagExists("fromDriver")) {
            args.showError();
        }
        if ((string = args.get("fromDriver")) != null) {
            System.out.println("dbname=" + DBName.fromDriver(string));
        }
    }
}

