/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.IOUtil;
import fc.jdbc.PooledConnectionMgr;
import fc.util.Argcheck;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;

public class PooledConnection
implements Connection {
    static int idCounter = 1;
    int id;
    PooledConnectionMgr pool;
    Connection connection;
    volatile boolean closed;
    int commitCount;
    int rollbackCount;
    int warningsCount;
    long transaction_start_time = 0L;
    private final Map pstmtMap = new IdentityHashMap(256);

    public PooledConnection(PooledConnectionMgr pooledConnectionMgr, Connection connection) {
        Argcheck.notnull(pooledConnectionMgr, "specified 'pool' arg was null");
        Argcheck.notnull(connection, "specifed 'con' arg was null");
        this.pool = pooledConnectionMgr;
        this.connection = connection;
        this.closed = false;
        this.id = PooledConnection.makeID();
    }

    private static final synchronized int makeID() {
        return idCounter++;
    }

    protected int getID() {
        return this.id;
    }

    void setClosed(boolean bl) {
        this.closed = bl;
    }

    void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("This connection has been closed");
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.setClosed(true);
            this.pool.put(this);
        } else {
            this.pool.log.bug("Tried to close already closed connection (#", this.id, ") =>", IOUtil.throwableToString(new Exception("Debug Stack Trace")));
        }
    }

    void closeReally() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getCachedPreparedStatement(String string) throws SQLException {
        string = string.intern();
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            if (this.pstmtMap.containsKey(string)) {
                PreparedStatement preparedStatement = (PreparedStatement)this.pstmtMap.get(string);
                preparedStatement.clearParameters();
                return preparedStatement;
            }
            PreparedStatement preparedStatement = this.prepareStatement(string, 1004, 1007);
            this.pstmtMap.put(string, preparedStatement);
            return preparedStatement;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("/PoolID:");
        stringBuilder.append(this.id);
        try {
            stringBuilder.append("/currentIsolation:");
            int n = this.getTransactionIsolation();
            switch (n) {
                case 0: {
                    stringBuilder.append("NONE");
                    break;
                }
                case 1: {
                    stringBuilder.append("READ_UNCOMMITTED");
                    break;
                }
                case 2: {
                    stringBuilder.append("READ_COMMITTED");
                    break;
                }
                case 4: {
                    stringBuilder.append("REPEATABLE_READ");
                    break;
                }
                case 8: {
                    stringBuilder.append("SERIALIZABLE");
                    break;
                }
                default: {
                    stringBuilder.append("Unknown: ");
                    stringBuilder.append(n);
                }
            }
            stringBuilder.append("/autoCommit:");
            stringBuilder.append(String.valueOf(this.getAutoCommit()).toUpperCase());
            if (this.transaction_start_time == 0L) {
                stringBuilder.append("/[no open transaction]");
            } else {
                stringBuilder.append("/[in open transaction,");
                stringBuilder.append(System.currentTimeMillis() - this.transaction_start_time);
                stringBuilder.append(" ms]");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        ++this.commitCount;
        this.transaction_start_time = 0L;
        this.connection.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.connection.createStatement(n, n2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        ++this.warningsCount;
        return this.connection.getWarnings();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.connection.prepareCall(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.connection.prepareCall(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.connection.prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.connection.prepareStatement(string, n, n2);
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.transaction_start_time = bl ? 0L : System.currentTimeMillis();
        this.connection.setAutoCommit(bl);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.connection.setHoldability(n);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return this.connection.setSavepoint(string);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        ++this.rollbackCount;
        this.connection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.connection.createStatement(n, n2, n3);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return this.connection.createStruct(string, objectArray);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.connection.getClientInfo(string);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.connection.setClientInfo(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return this.connection.createArrayOf(string, objectArray);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return this.connection.isValid(n);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.connection.isWrapperFor(clazz);
    }

    public Object unwrap(Class clazz) throws SQLException {
        return this.connection.unwrap(clazz);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.connection.prepareStatement(string, n, n2, n3);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.connection.prepareCall(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.connection.prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.connection.prepareStatement(string, nArray);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.connection.prepareStatement(string, stringArray);
    }
}

