/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.IOUtil;
import fc.io.Log;
import fc.util.Args;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class QueryReader {
    private static final boolean dbg = false;
    public static final int TEST_FIELD_1 = 1;
    public static final String TEST_FIELD_2 = "hello";
    Log log;
    Map queries = new LinkedHashMap();

    public QueryReader(File file) throws IOException {
        this(file, Log.getDefault());
    }

    public QueryReader(File file, Log log) throws IOException {
        String string;
        this.log = log;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder(1024);
        while ((string2 = bufferedReader.readLine()) != null) {
            string = string2.trim();
            if (string.length() == 0 || string.startsWith("#") || string.startsWith("//") || stringBuilder.length() == 0 && string.equals(";")) continue;
            String[] stringArray = string2.split("\\s+//", 2);
            string2 = stringArray[0];
            if (string.equals(";")) {
                this.processBuffer(stringBuilder);
                stringBuilder = new StringBuilder();
                continue;
            }
            if (string2.trim().endsWith(";")) {
                stringBuilder.append(string2.substring(0, string2.lastIndexOf(59)));
                this.processBuffer(stringBuilder);
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        string = stringBuilder.toString().trim();
        if (string.length() > 0) {
            this.log.error("No ending delimiter (';') seen, the following section was NOT processed: \n", string);
        }
        bufferedReader.close();
        this.log.info("Processed: ", this.queries.size(), " queries from file: ", file.getAbsolutePath());
    }

    void processBuffer(StringBuilder stringBuilder) {
        Object object;
        AnnotatedElement annotatedElement;
        Object object2;
        String string;
        String string2;
        String[] stringArray = stringBuilder.toString().split("=", 2);
        if (stringArray.length != 2) {
            this.log.error("Query sections must be of form 'name = value'. Badly formed section, NOT processed: \n", stringBuilder);
            return;
        }
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        if (this.queries.get(string3) != null) {
            this.log.error("This query name ", string3, " already exists prior to this section. Duplicate name NOT processed: \n", stringBuilder);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile("[^$]\\$\\s*([a-zA-Z_0-9.]+)\\s*\\$([a-zA-Z_0-9.]*)");
        Matcher matcher = pattern.matcher(string4);
        while (matcher.find()) {
            string2 = matcher.group(1);
            string = string2 + "Mgr";
            object2 = matcher.group(2);
            try {
                annotatedElement = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                Method method = null;
                object = null;
                if (object2 != null && !((String)object2).equals("")) {
                    method = ((Class)annotatedElement).getMethod("columns", String.class);
                    object = (String)method.invoke(null, object2);
                } else {
                    method = ((Class)annotatedElement).getMethod("columns", null);
                    object = (String)method.invoke(null, null);
                }
                matcher.appendReplacement(stringBuffer, (String)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error("Manager [", string, "] for [$", string2 + "$] not found, this query will NOT be added. Query:\n-----------------------\n", stringBuilder, "\n-----------------------\n");
                return;
            }
            catch (Exception exception) {
                this.log.error("Internal error while processing: ", stringBuilder);
                this.log.error("This query was NOT added");
                this.log.error(IOUtil.throwableToString(exception));
                return;
            }
        }
        matcher.appendTail(stringBuffer);
        pattern = Pattern.compile("\\$\\$\\s*([a-zA-Z_0-9.]+)\\.([a-zA-Z_0-9]+)\\s*\\$\\$");
        matcher = pattern.matcher(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        while (matcher.find()) {
            string2 = matcher.group(1);
            string = matcher.group(2);
            try {
                object2 = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                annotatedElement = ((Class)object2).getDeclaredField(string);
                int n = ((Field)annotatedElement).getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n)) {
                    throw new Exception("Darn! Field: [" + annotatedElement + "] was not declared static or final. It must be both for this reference to work!");
                }
                if (!Modifier.isPublic(n)) {
                    ((Field)annotatedElement).setAccessible(true);
                }
                object = ((Field)annotatedElement).get(null);
                matcher.appendReplacement(stringBuffer, String.valueOf(object));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error("Class [", string2, "] not found, this query will NOT be added. Query:\n-----------------------\n", stringBuilder, "\n-----------------------\n");
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.log.error("Field [", string, "] not found, this query will NOT be added. Query:\n-----------------------\n", stringBuilder, "\n-----------------------\n");
                return;
            }
            catch (Exception exception) {
                this.log.error("Internal error while processing: ", stringBuilder);
                this.log.error("This query was NOT added");
                this.log.error(IOUtil.throwableToString(exception));
                return;
            }
        }
        matcher.appendTail(stringBuffer);
        this.queries.put(string3, stringBuffer.toString());
    }

    public String getQuery(String string) {
        return (String)this.queries.get(string);
    }

    public Map getQueries() {
        return this.queries;
    }

    public static void main(String[] stringArray) throws IOException {
        Args args = new Args(stringArray);
        String string = args.getRequired("file");
        QueryReader queryReader = new QueryReader(new File(string));
        System.out.println("----------------- processed queries ------------------");
        System.out.println(queryReader.queries);
    }
}

