/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.IOUtil;
import fc.io.Log;
import fc.io.TablePrinter;
import fc.jdbc.DBName;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.jsp.JspWriter;

public final class QueryUtil {
    private static long txID = 1L;
    static Log log = Log.get("fc.web.servlet.QueryUtil");
    private static final String t_str = "*** ";

    private QueryUtil() {
    }

    public static final void init(Log log) {
        QueryUtil.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getNewTxID() {
        Class<QueryUtil> clazz = QueryUtil.class;
        synchronized (QueryUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return txID++;
        }
    }

    public static DBName getDBName(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        return DBName.fromDriver(databaseMetaData.getDriverName());
    }

    public static final void ensureScrollable(ResultSet resultSet) throws SQLException {
        if (resultSet.getType() == 1003) {
            throw new SQLException("Specified ResultSet not scrollable; need scrollable to proceed. [ResultSet=" + resultSet + "]");
        }
    }

    public static final void ensureCount(int n, int n2) throws SQLException {
        if (n != n2) {
            throw new SQLException("row count mismatch, recieved [" + n + "], expected [" + n2 + "]");
        }
    }

    public static final long getRowCount(ResultSet resultSet) throws SQLException {
        int n = 0;
        if (resultSet != null) {
            int n2 = resultSet.getType();
            if (n2 == 1003) {
                while (resultSet.next()) {
                    ++n;
                }
            } else {
                resultSet.last();
                n = resultSet.getRow();
                resultSet.beforeFirst();
            }
        }
        return n;
    }

    public static final long getLastInsertID(Connection connection, DBName dBName, Object object) throws SQLException {
        if (dBName == DBName.mysql) {
            String string = "select last_insert_id()";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            boolean bl = resultSet.next();
            if (!bl) {
                throw new SQLException("No last inserted id returned");
            }
            return resultSet.getLong(1);
        }
        if (dBName == DBName.postgres) {
            if (!(object instanceof String)) {
                throw new SQLException("postgres requires the info parameter as a String");
            }
            String string = "select currval('" + object + "')";
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            boolean bl = resultSet.next();
            if (!bl) {
                throw new SQLException("No last inserted id returned");
            }
            return resultSet.getLong(1);
        }
        throw new SQLException("Method not yet implemented for database of type: " + dBName);
    }

    public static final List executeQuery(Connection connection, String string) throws SQLException {
        return QueryUtil.executeQuery(connection, string, false);
    }

    public static final List executeQuery(Connection connection, String string, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        List list = QueryUtil.rsToList(resultSet, bl);
        return list;
    }

    public static final boolean hasExactlyOneRow(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        boolean bl = QueryUtil.getRowCount(resultSet) == 1L;
        return bl;
    }

    public static final boolean hasExactlyZeroRows(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        boolean bl = QueryUtil.getRowCount(resultSet) == 0L;
        return bl;
    }

    public static final Statement getRewindableStmt(Connection connection) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        return statement;
    }

    public static final PreparedStatement getRewindablePreparedStmt(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string, 1004, 1007);
        return preparedStatement;
    }

    public static final boolean startTransaction(Connection connection, int n, String string) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The specfied transaction isolation level " + n + " is not a valid value");
            }
        }
        try {
            connection.setTransactionIsolation(n);
        }
        catch (Exception exception) {
            log.error("Could not set transaction isolation;", IOUtil.throwableToString(exception));
            return false;
        }
        return QueryUtil.startTransaction(connection, string);
    }

    public static final boolean startTransaction(Connection connection, String string) {
        boolean bl = true;
        try {
            connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            log.error(string, "Could not set autoCommit(false) on this connection; Transaction will not be started and the connection will be closed. ", connection, IOUtil.throwableToString(exception));
            try {
                connection.close();
            }
            catch (Exception exception2) {
                log.error(string, "Connection does not allow autoCommit(false) and connetion cannot even be closed. ", connection, IOUtil.throwableToString(exception2));
            }
            bl = false;
        }
        log.bug(string, "/START: Transaction [Isolation Level=", QueryUtil.getTransactionLevelString(connection), "];", connection);
        return bl;
    }

    public static final boolean startTransaction(Connection connection) {
        return QueryUtil.startTransaction(connection, t_str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean abortTransaction(Connection connection, String string) {
        boolean bl = true;
        try {
            if (connection.getAutoCommit()) {
                log.error("Connection not in transaction, autoCommit is true. Did you call QueryUtil.startTransaction() on this connection ?", string, connection);
                return false;
            }
        }
        catch (Exception exception) {
            log.error(IOUtil.throwableToString(exception));
            return false;
        }
        try {
            connection.rollback();
        }
        catch (Throwable throwable) {
            bl = false;
            log.error(string, "*** Transaction could not be aborted/rolled back ***", IOUtil.throwableToString(throwable));
        }
        finally {
            try {
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                log.error(string, "Could NOT reset connection to be autoCommit=true", connection, IOUtil.throwableToString(exception));
                bl = false;
            }
        }
        if (log.canLog(Log.DEBUG)) {
            log.bug(string, "/ABORT: Transaction rolled back [Time=", new Date(), "]; connection=", connection);
        }
        return bl;
    }

    public static final boolean abortTransaction(Connection connection) {
        return QueryUtil.abortTransaction(connection, t_str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean endTransaction(Connection connection, String string) {
        boolean bl = true;
        try {
            if (connection.getAutoCommit()) {
                log.error("Connection not in transaction, autoCommit is true. Did you prior call QueryUtil.startTransaction() on this connection ?", string, connection);
                return false;
            }
        }
        catch (Exception exception) {
            log.error(IOUtil.throwableToString(exception));
            return false;
        }
        try {
            connection.commit();
        }
        catch (Throwable throwable) {
            bl = false;
            log.error(string, "*** Transaction could not complete: attempting roll back ***", IOUtil.throwableToString(throwable));
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                log.error(string, "*** Transaction could not be rolled back ***", IOUtil.throwableToString(sQLException));
            }
        }
        finally {
            try {
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                log.error(string, "Could NOT reset connection to be autoCommit=true", connection, IOUtil.throwableToString(exception));
                bl = false;
            }
        }
        log.bug(string, "/FINISH: Transaction completed. Connection=", connection);
        return bl;
    }

    public static final boolean endTransaction(Connection connection) {
        return QueryUtil.endTransaction(connection, t_str);
    }

    private static String getTransactionLevelString(Connection connection) {
        try {
            int n = connection.getTransactionIsolation();
            switch (n) {
                case 0: {
                    return "TRANSACTION_NONE";
                }
                case 2: {
                    return "TRANSACTION_READ_COMMITTED";
                }
                case 1: {
                    return "TRANSACTION_READ_UNCOMMITTED";
                }
                case 4: {
                    return "TRANSACTION_REPEATABLE_READ";
                }
                case 8: {
                    return "TRANSACTION_SERIALIZABLE";
                }
            }
            return "Unknown level (not a legal value)";
        }
        catch (Exception exception) {
            log.error(IOUtil.throwableToString(exception));
            return "";
        }
    }

    public static final void rollback(Connection connection) {
        try {
            if (connection.isClosed()) {
                log.bug("tried to rollback a already closed connection: ", connection);
                return;
            }
            connection.rollback();
        }
        catch (Exception exception) {
            log.error(IOUtil.throwableToString(exception));
        }
    }

    public static final void close(ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
    }

    public static final void close(Connection connection) {
        QueryUtil.close(null, null, connection);
    }

    public static final List rsToList(ResultSet resultSet, boolean bl) throws SQLException {
        int n;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        Object[] objectArray = null;
        if (bl) {
            objectArray = new Object[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
            }
            arrayList.add(objectArray);
        }
        while (resultSet.next()) {
            objectArray = new Object[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSet.getObject(n);
            }
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public static final String rsListToString(List list) {
        String string = "";
        if (list == null) {
            return string;
        }
        int n = list.size();
        string = string + "Total records: " + n + IOUtil.LINE_SEP;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])list.get(i);
            int n2 = objectArray.length;
            string = string + "[";
            for (int j = 0; j < n2; ++j) {
                string = string + objectArray[j];
                if (j + 1 == n2) continue;
                string = string + ", ";
            }
            string = string + "]";
            if (i + 1 == n) continue;
            string = string + ", ";
        }
        return string;
    }

    public static final void printRS(ResultSet resultSet) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        System.out.print("[Headers] ");
        for (n = 1; n <= n2; ++n) {
            System.out.print(resultSetMetaData.getColumnLabel(n));
            if (n == n2) continue;
            System.out.print(", ");
        }
        System.out.println("");
        n = 0;
        while (resultSet.next()) {
            System.out.print("[Row #" + ++n + " ] ");
            for (int i = 1; i <= n2; ++i) {
                String string;
                Object object = resultSet.getObject(i);
                String string2 = string = object != null ? object.toString() : "null";
                if (string.length() > 0) {
                    System.out.print(string);
                } else {
                    System.out.print("\"\"");
                }
                if (i == n2) continue;
                System.out.print(", ");
            }
            System.out.println("");
        }
    }

    public static final void printResultSetTable(ResultSet resultSet, PrintStream printStream) throws SQLException {
        QueryUtil.printResultSetTable(resultSet, printStream, ResultSetPrintDirection.HORIZONTAL, null, true);
    }

    public static final void printResultSetTable(ResultSet resultSet, PrintStream printStream, ResultSetPrintDirection resultSetPrintDirection, TablePrinter.PrintConfig printConfig, boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        TablePrinter tablePrinter = null;
        if (printConfig == null) {
            printConfig = new TablePrinter.PrintConfig();
            printConfig.setCellPadding(1);
        }
        if (resultSetPrintDirection == ResultSetPrintDirection.HORIZONTAL) {
            int n2;
            tablePrinter = new TablePrinter(n, printStream, printConfig);
            tablePrinter.startTable();
            if (bl) {
                tablePrinter.startRow();
                for (n2 = 1; n2 <= n; ++n2) {
                    tablePrinter.printCell(resultSetMetaData.getColumnLabel(n2));
                }
                tablePrinter.endRow();
            }
            while (resultSet.next()) {
                tablePrinter.startRow();
                for (n2 = 1; n2 <= n; ++n2) {
                    tablePrinter.printCell(resultSet.getString(n2));
                }
                tablePrinter.endRow();
            }
            tablePrinter.endTable();
        } else if (resultSetPrintDirection == ResultSetPrintDirection.VERTICAL) {
            int n3;
            if (resultSet.getType() == 1003) {
                printStream.println("QueryUtil.printResultSet(): Vertical print orientation requires a scrollable resultset");
                return;
            }
            resultSet.last();
            int n4 = resultSet.getRow();
            int n5 = n3 = bl ? n4 + 1 : n4;
            if (printConfig.getHeader() != null) {
                printStream.println("QueryUtil.printResultSet(): Seperate headers not supported when using Vertical orientation. To print Result Set headers, specify 'true' for the 'header' parameter when invoking this method");
                return;
            }
            tablePrinter = new TablePrinter(n3, printStream, printConfig);
            resultSet.beforeFirst();
            tablePrinter.startTable();
            for (int i = 1; i <= n; ++i) {
                tablePrinter.startRow();
                if (bl) {
                    tablePrinter.printCell(resultSetMetaData.getColumnLabel(i));
                }
                while (resultSet.next()) {
                    tablePrinter.printCell(resultSet.getString(i));
                }
                tablePrinter.endRow();
                resultSet.beforeFirst();
            }
            tablePrinter.endTable();
        } else {
            printStream.println("QueryUtil.printResultSet(): PrintConfig not understood");
        }
    }

    public static final void printResultSetHTMLTable(ResultSet resultSet, JspWriter jspWriter, ResultSetPrintDirection resultSetPrintDirection) throws IOException, SQLException {
        boolean bl = true;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        jspWriter.println("<table class=\"QueryUtil_Table\">");
        if (resultSetPrintDirection == ResultSetPrintDirection.HORIZONTAL) {
            int n2;
            if (bl) {
                jspWriter.print("<tr class=\"QueryUtil_HeaderRow\">");
                for (n2 = 1; n2 <= n; ++n2) {
                    jspWriter.print("<td class=\"QueryUtil_HeaderCell\">");
                    jspWriter.print(resultSetMetaData.getColumnLabel(n2));
                    jspWriter.print("</td>");
                }
                jspWriter.println("</tr>");
            }
            while (resultSet.next()) {
                jspWriter.println("<tr class=\"QueryUtil_Row\">");
                for (n2 = 1; n2 <= n; ++n2) {
                    jspWriter.print("<td class=\"QueryUtil_Cell\">");
                    jspWriter.print(resultSet.getString(n2));
                    jspWriter.print("</td>");
                }
                jspWriter.println("</tr>");
            }
            jspWriter.println("</table>");
        } else if (resultSetPrintDirection == ResultSetPrintDirection.VERTICAL) {
            if (resultSet.getType() == 1003) {
                jspWriter.println("QueryUtil.printResultSet(): Vertical print orientation requires a scrollable resultset");
                return;
            }
            resultSet.last();
            int n3 = resultSet.getRow();
            int n4 = bl ? n3 + 1 : n3;
            resultSet.beforeFirst();
            jspWriter.println("<table class=\"QueryUtil_Table\">");
            for (int i = 1; i <= n; ++i) {
                jspWriter.println("<tr>");
                if (bl) {
                    jspWriter.print("<td class=\"QueryUtil_HeaderCell\">");
                    jspWriter.println(resultSetMetaData.getColumnLabel(i));
                    jspWriter.println("</td>");
                }
                while (resultSet.next()) {
                    jspWriter.println("<td class=\"QueryUtil_Cell\">");
                    jspWriter.println(resultSet.getString(i));
                    jspWriter.println("</td>");
                }
                jspWriter.println("</tr>");
                resultSet.beforeFirst();
            }
            jspWriter.println("</table>");
        }
    }

    public static final void printResultSetHTMLTable(ResultSet resultSet, PrintWriter printWriter, ResultSetPrintDirection resultSetPrintDirection) throws IOException, SQLException {
        boolean bl = true;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        printWriter.println("<table class=\"QueryUtil_Table\">");
        if (resultSetPrintDirection == ResultSetPrintDirection.HORIZONTAL) {
            int n2;
            if (bl) {
                printWriter.print("<tr class=\"QueryUtil_HeaderRow\">");
                for (n2 = 1; n2 <= n; ++n2) {
                    printWriter.print("<td class=\"QueryUtil_HeaderCell\">");
                    printWriter.print(resultSetMetaData.getColumnLabel(n2));
                    printWriter.print("</td>");
                }
                printWriter.println("</tr>");
            }
            while (resultSet.next()) {
                printWriter.println("<tr class=\"QueryUtil_Row\">");
                for (n2 = 1; n2 <= n; ++n2) {
                    printWriter.print("<td class=\"QueryUtil_Cell\">");
                    printWriter.print(resultSet.getString(n2));
                    printWriter.print("</td>");
                }
                printWriter.println("</tr>");
            }
            printWriter.println("</table>");
        } else if (resultSetPrintDirection == ResultSetPrintDirection.VERTICAL) {
            if (resultSet.getType() == 1003) {
                printWriter.println("QueryUtil.printResultSet(): Vertical print orientation requires a scrollable resultset");
                return;
            }
            resultSet.last();
            int n3 = resultSet.getRow();
            int n4 = bl ? n3 + 1 : n3;
            resultSet.beforeFirst();
            printWriter.println("<table class=\"QueryUtil_Table\">");
            for (int i = 1; i <= n; ++i) {
                printWriter.println("<tr>");
                if (bl) {
                    printWriter.print("<td class=\"QueryUtil_HeaderCell\">");
                    printWriter.println(resultSetMetaData.getColumnLabel(i));
                    printWriter.println("</td>");
                }
                while (resultSet.next()) {
                    printWriter.println("<td class=\"QueryUtil_Cell\">");
                    printWriter.println(resultSet.getString(i));
                    printWriter.println("</td>");
                }
                printWriter.println("</tr>");
                resultSet.beforeFirst();
            }
            printWriter.println("</table>");
        }
    }

    public static final class ResultSetPrintDirection {
        public static final ResultSetPrintDirection HORIZONTAL = new ResultSetPrintDirection("QueryUtil.ResultSetPrintDirection.HORIZONTAL");
        public static final ResultSetPrintDirection VERTICAL = new ResultSetPrintDirection("QueryUtil.ResultSetPrintDirection.VERTICAL");
        private String name;

        private ResultSetPrintDirection(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

