/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.jdbc.QueryUtil;
import fc.jdbc.SimpleConnectionMgr;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class ResultSetTransform
implements ResultSet {
    static final boolean dbg = false;
    ResultSet rs;
    ResultSetMetaData rsmd;
    Map transformsByIndex;
    Map ColNameIndex;

    public ResultSetTransform(ResultSet resultSet) throws SQLException {
        Argcheck.notnull(resultSet, "specified resultset argument was null");
        this.rs = resultSet;
        this.rsmd = resultSet.getMetaData();
        this.transformsByIndex = new HashMap();
        this.ColNameIndex = new HashMap();
    }

    public void addColumnTransform(int n, Rule rule) throws SQLException {
        Argcheck.istrue(n > 0, "column index must be greater than zero");
        Argcheck.notnull(rule, "specified rule cannot be null");
        this.transformsByIndex.put(new Integer(n), rule);
    }

    public void addColumnTransform(String string, Rule rule) throws SQLException {
        Argcheck.notnull(string, "column name must not be null");
        Argcheck.notnull(rule, "specified rule cannot be null");
        Integer n = new Integer(this.rs.findColumn(string));
        this.ColNameIndex.put(string, n);
        this.transformsByIndex.put(n, rule);
    }

    Object applyRule(Integer n, Object object) {
        if (this.transformsByIndex.containsKey(n)) {
            Rule rule = (Rule)this.transformsByIndex.get(n);
            return rule.transform(n, object);
        }
        return object;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "./ConnectionMgrTestProps.txt";
        Args args = new Args(stringArray);
        args.setUsage("java fc.jdbc.ResultSetTransform -query query-to-execute -colname columnName");
        String string2 = args.getRequired("query");
        String string3 = args.getRequired("colname");
        SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(new FilePropertyMgr(new File(string)));
        ResultSet resultSet = simpleConnectionMgr.getConnection().createStatement().executeQuery(string2);
        ResultSetTransform resultSetTransform = new ResultSetTransform(resultSet);
        Rule rule = new Rule(resultSetTransform){

            @Override
            public Object transform(int n, Object object) {
                return "transformed[col(" + n + ")]: " + object;
            }
        };
        resultSetTransform.addColumnTransform(string3, rule);
        QueryUtil.printResultSetTable(resultSetTransform, System.out);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Integer n2 = new Integer(n);
        return this.applyRule(n2, this.rs.getObject(n));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        Integer n = (Integer)this.ColNameIndex.get(string);
        return this.applyRule(n, this.rs.getObject(string));
    }

    @Override
    public String getString(int n) throws SQLException {
        Integer n2 = new Integer(n);
        String string = (String)this.applyRule(n2, this.rs.getString(n));
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        Integer n = (Integer)this.ColNameIndex.get(string);
        String string2 = (String)this.applyRule(n, this.rs.getString(string));
        return string2;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(n);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return this.rs.getByte(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        return this.rs.getShort(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        return this.rs.getInt(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        return this.rs.getLong(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return this.rs.getFloat(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return this.rs.getDouble(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rs.getBigDecimal(n, n2);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.rs.getUnicodeStream(n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(n);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(string);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.rs.getByte(string);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.rs.getShort(string);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.rs.getInt(string);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.rs.getLong(string);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.rs.getFloat(string);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.rs.getDouble(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rs.getBigDecimal(string, n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(string);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.rs.getDate(string);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.rs.getTime(string);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(string);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(string);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.rs.getUnicodeStream(string);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(string);
    }

    @Override
    public boolean next() throws SQLException {
        return this.rs.next();
    }

    @Override
    public void close() throws SQLException {
        this.rs.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(string);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(string);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.rs.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.rs.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return this.rs.absolute(n);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.rs.relative(n);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.rs.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.rs.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.rs.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.rs.updateNull(n);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.rs.updateBoolean(n, bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.rs.updateByte(n, by);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.rs.updateShort(n, s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.rs.updateInt(n, n2);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.rs.updateLong(n, l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.rs.updateFloat(n, f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.rs.updateDouble(n, d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.rs.updateString(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.rs.updateBytes(n, byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.rs.updateDate(n, date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.rs.updateTime(n, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.rs.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.rs.updateObject(n, object, n2);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.rs.updateObject(n, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.rs.updateNull(string);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.rs.updateBoolean(string, bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.rs.updateByte(string, by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.rs.updateShort(string, s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.rs.updateInt(string, n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.rs.updateLong(string, l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.rs.updateFloat(string, f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.rs.updateDouble(string, d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.rs.updateString(string, string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.rs.updateBytes(string, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.rs.updateDate(string, date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.rs.updateTime(string, time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.rs.updateTimestamp(string, timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.rs.updateCharacterStream(string, reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.rs.updateObject(string, object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.rs.updateObject(string, object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.rs.getObject(n, map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(n);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        return this.rs.getClob(n);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return this.rs.getArray(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.rs.getObject(string, map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.rs.getRef(string);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.rs.getBlob(string);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.rs.getClob(string);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.rs.getArray(string);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(n, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(string, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(n, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(string, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(string, calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return this.rs.getURL(n);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.rs.getURL(string);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.rs.updateRef(n, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.rs.updateRef(string, ref);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.rs.updateBlob(n, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.rs.updateBlob(string, blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.rs.updateClob(n, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.rs.updateClob(string, clob);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.rs.updateArray(n, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.rs.updateArray(string, array);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.rs.updateNClob(string, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.rs.updateNClob(n, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(string, reader, l);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.rs.updateNClob(string, nClob);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.rs.updateNClob(n, nClob);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.rs.updateNString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.rs.updateNString(string, string2);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.rs.updateClob(string, reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.rs.updateClob(n, reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.rs.updateClob(string, reader, l);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.rs.updateClob(n, reader);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(n, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBlob(string, inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBlob(string, inputStream, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(string, reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateCharacterStream(n, reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.rs.updateNCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(string, reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.rs.updateNCharacterStream(n, reader, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(string, inputStream, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.rs.updateAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.rs.updateRowId(n, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.rs.updateRowId(string, rowId);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.rs.updateSQLXML(string, sQLXML);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rs.getHoldability();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        return this.rs.getRowId(n);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.rs.getRowId(string);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return this.rs.getNClob(n);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.rs.getNClob(string);
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.rs.getNString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.rs.getNString(string);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.rs.getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.rs.getNCharacterStream(string);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return this.rs.getSQLXML(n);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.rs.getSQLXML(string);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rs.isClosed();
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return this.rs.isWrapperFor(clazz);
    }

    public Object unwrap(Class clazz) throws SQLException {
        return this.rs.unwrap(clazz);
    }

    public abstract class Rule {
        protected abstract Object transform(int var1, Object var2);

        public ResultSet getResultSet() {
            return ResultSetTransform.this.rs;
        }

        public ResultSetMetaData getMetaData() {
            return ResultSetTransform.this.rsmd;
        }
    }
}

