/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.IOUtil;
import fc.io.SystemLog;
import fc.jdbc.dbo.Table;
import fc.jdbc.dbo.Types;
import fc.util.PropertyMgr;
import fc.util.ToString;
import java.sql.SQLException;

class ColumnData {
    static boolean nullIfNullableUnknown;
    static SystemLog log;
    static Types types;
    static ToString.Style style;
    private Table table;
    private String colname;
    private int colnum;
    private int sqltype;
    private String typename;
    private int colsize;
    private boolean nullable;
    private boolean isAutoIncrement;
    private String remarks;
    private boolean hasRemarks;
    private String default_val;
    private boolean isPK;
    private FKData fkdata;

    static void init(SystemLog systemLog, PropertyMgr propertyMgr) {
        log = systemLog;
        types = new Types(systemLog, propertyMgr);
    }

    ColumnData(Table table, String string, int n, int n2, String string2, int n3, int n4, boolean bl, String string3, String string4) {
        this.table = table;
        this.colname = string;
        this.colnum = n;
        this.sqltype = n2;
        this.typename = string2;
        this.colsize = n3;
        this.isAutoIncrement = bl;
        this.hasRemarks = string3 != null && !string3.equals("");
        this.remarks = string3;
        this.default_val = string4;
        switch (n4) {
            case 0: {
                this.nullable = false;
                break;
            }
            case 1: {
                this.nullable = true;
                break;
            }
            case 2: {
                this.nullable = nullIfNullableUnknown;
            }
            default: {
                throw new IllegalArgumentException("received unknown value for NULLABLE field from DBMetaData.getColumns(), value=" + n4);
            }
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setPK(boolean bl) {
        this.isPK = bl;
    }

    public void setFK(String string, String string2, String string3) {
        this.fkdata = new FKData(string, string2, string3);
    }

    public String getName() {
        return this.colname;
    }

    public int getSize() {
        return this.colsize;
    }

    public int getNumber() {
        return this.colnum;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public boolean hasDefaultValue() {
        return this.default_val != null;
    }

    public String getDefaultValue() {
        return this.default_val;
    }

    public FKData getFK() {
        return this.fkdata;
    }

    public String getResultSetMethod() throws SQLException {
        return types.getResultSetMethod(this.sqltype, String.valueOf(this.colnum), this);
    }

    public String getResultSetMethod(int n) throws SQLException {
        return types.getResultSetMethod(this.sqltype, String.valueOf(n), this);
    }

    public String getResultSetMethod(String string) throws SQLException {
        String string2 = string != null ? "\"" + string + this.colname + "\"" : "\"" + this.colname + "\"";
        return types.getResultSetMethod(this.sqltype, string2, this);
    }

    public String getRuntimeResultSetMethod() throws SQLException {
        return types.getRuntimeResultSetMethod(this.sqltype, this.colname, this);
    }

    public String getPreparedStmtSetMethod(String string, String string2, String string3) throws SQLException {
        return types.getPreparedStmtSetMethod(this.sqltype, string, string2, string3, this);
    }

    public String getPreparedStmtSetNullMethod(String string, String string2) throws SQLException {
        return types.getPreparedStmtSetNullMethod(this.sqltype, string, string2, this);
    }

    public boolean usesPrimitiveJavaType() throws SQLException {
        return types.usesPrimitiveJavaType(this.sqltype, this);
    }

    public boolean usesSimpleIntegralJavaType() throws SQLException {
        return types.usesSimpleIntegralJavaType(this.sqltype);
    }

    public String getJavaTypeFromSQLType() throws SQLException {
        return types.getJavaTypeFromSQLType(this.sqltype, this);
    }

    public int getSQLType() {
        return this.sqltype;
    }

    public String getSQLTypeName() {
        return types.getSQLTypeName(this.sqltype);
    }

    public String getSQLTypeDriverSpecificName() {
        return this.typename;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public boolean hasRemarks() {
        return this.hasRemarks;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public boolean isFK() {
        return this.fkdata != null;
    }

    boolean useBooleanObject() {
        return (this.sqltype == -7 || this.sqltype == 16) && this.isNullable() && ColumnData.types.booleanObjectForNullableBooleans;
    }

    public String toString() {
        return new ToString((Object)this, style).reflect().render();
    }

    static {
        style = new ToString.Style();
        ColumnData.style.reflectVisibleLevel = ToString.Style.VisibleLevel.PRIVATE;
        ColumnData.style.startString = IOUtil.LINE_SEP;
        ColumnData.style.endString = IOUtil.LINE_SEP;
    }

    public static class FKData {
        String fk_colname;
        String pk_table;
        String pk_colname;
        static final ToString.Style style = new ToString.Style();

        FKData(String string, String string2, String string3) {
            this.fk_colname = string;
            this.pk_table = string2;
            this.pk_colname = string3;
        }

        public String getFKColName() {
            return this.fk_colname;
        }

        public String getPKColName() {
            return this.pk_colname;
        }

        public String getPKTableName() {
            return this.pk_table;
        }

        public String toString() {
            return new ToString((Object)this, style).reflect().render();
        }

        static {
            FKData.style.reflectVisibleLevel = ToString.Style.VisibleLevel.DEFAULT;
        }
    }
}

