/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.Log;
import fc.io.SystemLog;
import fc.jdbc.DBName;
import fc.jdbc.SimpleConnectionMgr;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import java.io.File;
import java.sql.Connection;
import java.sql.Statement;

public class CreateAllTypes {
    static DBName dbname;
    static String tablename;

    public static void main(String[] stringArray) throws Exception {
        String string = "alltypes";
        Args args = new Args(stringArray);
        args.setUsage("java CreateAllTypes -conf conf_file [-db db_schema] [-table table_name_to_create]");
        String string2 = args.get("db");
        String string3 = args.getRequired("conf");
        tablename = args.get("table", string);
        Log.getDefault().setLevel(SystemLog.DEBUG);
        FilePropertyMgr filePropertyMgr = new FilePropertyMgr(new File(string3));
        SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(filePropertyMgr);
        String string4 = filePropertyMgr.get("jdbc.url");
        if (string4.indexOf("postgres") != -1) {
            dbname = DBName.postgres;
        } else if (string4.indexOf("mysql") != -1) {
            dbname = DBName.mysql;
        } else if (string4.indexOf("oracle") != -1) {
            dbname = DBName.oracle;
        } else {
            throw new Exception("I do not understand this database type. Only mysql/postgresql supported currently.");
        }
        Connection connection = simpleConnectionMgr.getConnection();
        if (string2 != null) {
            connection.setCatalog(string2);
        }
        String string5 = CreateAllTypes.getSQL();
        Statement statement = connection.createStatement();
        System.out.println("Creating table..");
        int n = statement.executeUpdate(string5);
        System.out.println("...done [success]");
        connection.close();
    }

    static String getSQL() {
        String string = "create table " + tablename + " ( ";
        string = string + (dbname == DBName.mysql ? "id\t\t\t\t\tint auto_increment, " : "id\t\t\t\t\tserial, ");
        string = string + "smallint_val\t\tsmallint, int_val\t\t\t\tint not null, bigint_val\t\t\tbigint, float_val\t\t\tfloat(24), double_val\t\t\tfloat(53), numeric_val\t\t\tnumeric(5,2), char_val\t\t\tchar(10), varchar_val\t\t\tvarchar(10), longvarchar_val\t\ttext, date_val\t\t\tdate, time_val\t\t\ttime, timestamp_val\t\ttimestamp, bit_val\t\t\t\tbit, ";
        string = string + (dbname == DBName.mysql ? "boolean_val\t\t\tbool, varbinary_val\t\tblob, " : "boolean_val\t\t\tboolean, varbinary_val\t\tbytea, ");
        if (dbname == DBName.mysql) {
            string = string + "json_val\t\t\t\tjson, ";
        } else if (dbname == DBName.postgres) {
            string = string + "array_val\t\t\tvarchar(10)[], json_val\t\t\t\tjson, jsonb_val\t\t\tjsonb, ";
        }
        string = string + " PRIMARY KEY (id) )";
        return string;
    }
}

