/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.SystemLog;
import fc.jdbc.QueryUtil;
import fc.jdbc.dbo.ColumnData;
import fc.jdbc.dbo.DBspecific;
import fc.jdbc.dbo.Generate;
import fc.util.MiscUtil;
import fc.util.PropertyMgr;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Table {
    static Generate generate;
    static DatabaseMetaData md;
    static SystemLog log;
    static DBspecific dbspecific;
    private static boolean is_postgres;
    private static boolean is_mysql;
    Connection con;
    String tablename;
    String tabletype;
    String remarks;
    Map columnMap = new HashMap();
    List columnList = new ArrayList();
    List pkList = new ArrayList();
    List fkList = new ArrayList();
    static final ColumnComparator column_comparator;

    Table(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        this.con = connection;
        this.tablename = string3;
        this.tabletype = string4;
        this.remarks = string5;
        this.readTable(string, string2);
    }

    static void init(Generate generate, DatabaseMetaData databaseMetaData, SystemLog systemLog, PropertyMgr propertyMgr, DBspecific dBspecific) {
        Table.generate = generate;
        md = databaseMetaData;
        dbspecific = dBspecific;
        log = systemLog;
        ColumnData.init(systemLog, propertyMgr);
    }

    private void readTable(String string, String string2) throws SQLException {
        String string3;
        String string4;
        String string5 = "%";
        ResultSet resultSet = md.getColumns(string, string2, this.tablename, string5);
        QueryUtil.ensureScrollable(resultSet);
        resultSet.beforeFirst();
        while (resultSet.next()) {
            string4 = resultSet.getString("COLUMN_NAME");
            int n = resultSet.getInt("DATA_TYPE");
            string3 = resultSet.getString("TYPE_NAME");
            int n2 = resultSet.getInt("COLUMN_SIZE");
            int n3 = resultSet.getInt("NULLABLE");
            boolean bl = dbspecific.isAutoIncrement(this.con, this.tablename, string4, resultSet);
            String string6 = resultSet.getString("REMARKS");
            int n4 = resultSet.getInt("ORDINAL_POSITION");
            String string7 = resultSet.getString("COLUMN_DEF");
            if (MiscUtil.isJavaKeyword(string4)) {
                throw new SQLException("The colname [" + string4 + "] for table [" + this.tablename + "] is a Java Reserved Keyword. Either change the column name in the DB or exclude this table in the config file");
            }
            if (string3.toLowerCase().indexOf("enum") >= 0 && n != 1111 && generate.isPostgres()) {
                log.warn("postgres 'enum' type found for column (", string4, ") - the driver thinks this is a String");
                log.warn("and will then cause a Postgres error when saving it back to the DB. To get around this:");
                log.warn("specify 'stringtype=unspecified' in the JDBC url!");
            }
            ColumnData columnData = new ColumnData(this, string4, n4, n, string3, n2, n3, bl, string6, string7);
            this.columnMap.put(columnData.getName(), columnData);
            this.columnList.add(columnData);
        }
        Collections.sort(this.columnList, column_comparator);
        resultSet = md.getPrimaryKeys(string, null, this.tablename);
        while (resultSet.next()) {
            string4 = resultSet.getString("COLUMN_NAME");
            ColumnData columnData = (ColumnData)this.columnMap.get(string4);
            if (columnData == null) {
                throw new IllegalStateException("Cannot locate PK column. This should not happen since DatabaseMetaData.getPrimaryKeys() should be a subset of DatabaseMetaData.getColumns()");
            }
            columnData.setPK(true);
            this.pkList.add(columnData);
        }
        Collections.sort(this.pkList, column_comparator);
        resultSet = md.getImportedKeys(string, null, this.tablename);
        while (resultSet.next()) {
            string4 = resultSet.getString("PKTABLE_NAME");
            String string8 = resultSet.getString("PKCOLUMN_NAME");
            string3 = resultSet.getString("FKCOLUMN_NAME");
            ColumnData columnData = (ColumnData)this.columnMap.get(string3);
            if (columnData == null) {
                throw new IllegalStateException("Cannot locate FK column. This should not happen since DatabaseMetaData.getImportedKeys() should be a subset of DatabaseMetaData.getColumns()");
            }
            columnData.setFK(string3, string4, string8);
            this.fkList.add(columnData);
        }
        Collections.sort(this.fkList, column_comparator);
        log.bug("Columns=", this.columnList);
        log.bug("PK List=", this.pkList);
        log.bug("FK List=", this.fkList);
    }

    String getName() {
        return this.tablename;
    }

    String getType() {
        return this.tabletype;
    }

    String getRemarks() {
        return this.remarks;
    }

    List getColumnList() {
        return this.columnList;
    }

    int getColumnCount() {
        return this.columnList.size();
    }

    ColumnData getColumn(String string) {
        return (ColumnData)this.columnMap.get(string);
    }

    List getFKList() {
        return this.fkList;
    }

    List getPKList() {
        return this.pkList;
    }

    public String toString() {
        return this.tablename;
    }

    static String getListAsString(List list) {
        int n = list.size();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 10);
        ColumnData columnData = (ColumnData)list.get(0);
        stringBuffer.append(columnData.getName());
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", ");
                columnData = (ColumnData)list.get(i);
                stringBuffer.append(columnData.getName());
            }
        }
        return stringBuffer.toString();
    }

    String getFullyQualifiedColumnString() {
        int n = this.columnList.size();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 10);
        ColumnData columnData = (ColumnData)this.columnList.get(0);
        stringBuffer.append(this.tablename);
        stringBuffer.append(".");
        stringBuffer.append(columnData.getName());
        stringBuffer.append(" as ");
        stringBuffer.append(this.tablename);
        stringBuffer.append("_");
        stringBuffer.append(columnData.getName());
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", ");
                columnData = (ColumnData)this.columnList.get(i);
                stringBuffer.append(this.tablename);
                stringBuffer.append(".");
                stringBuffer.append(columnData.getName());
                stringBuffer.append(" as ");
                stringBuffer.append(this.tablename);
                stringBuffer.append("_");
                stringBuffer.append(columnData.getName());
            }
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    String getPrefixQualifiedColumnString() {
        int n = this.columnList.size();
        if (n == 0) {
            return "\treturn \"\";\n";
        }
        String string = "";
        string = string + "\tfinal StringBuffer buf = new StringBuffer(" + n + " * 10);\n\n";
        ColumnData columnData = (ColumnData)this.columnList.get(0);
        string = string + "\tbuf.append(prefix);\n";
        string = string + "\tbuf.append(\".\");\n";
        string = string + "\tbuf.append(\"" + columnData.getName() + "\");\n";
        string = string + "\tbuf.append(\" as \");\n";
        string = string + "\tbuf.append(prefix);\n";
        string = string + "\tbuf.append(\"_\");\n";
        string = string + "\tbuf.append(\"" + columnData.getName() + "\");\n";
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                string = string + "\n";
                string = string + "\tbuf.append(\", \");\n";
                columnData = (ColumnData)this.columnList.get(i);
                string = string + "\tbuf.append(prefix);\n";
                string = string + "\tbuf.append(\".\");\n";
                string = string + "\tbuf.append(\"" + columnData.getName() + "\");\n";
                string = string + "\tbuf.append(\" as \");\n";
                string = string + "\tbuf.append(prefix);\n";
                string = string + "\tbuf.append(\"_\");\n";
                string = string + "\tbuf.append(\"" + columnData.getName() + "\");\n";
            }
        }
        string = string + "\tbuf.append(\" \");\n\n";
        string = string + "\treturn buf.toString();\n";
        return string;
    }

    static String getPreparedStmtPlaceholders(List list) {
        int n = list.size();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        ColumnData columnData = (ColumnData)list.get(0);
        stringBuffer.append(columnData.getName());
        stringBuffer.append("=?");
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                columnData = (ColumnData)list.get(i);
                stringBuffer.append(" and ");
                stringBuffer.append(columnData.getName());
                stringBuffer.append("=?");
            }
        }
        return stringBuffer.toString();
    }

    static {
        column_comparator = new ColumnComparator();
    }

    private static class ColumnComparator
    implements Comparator {
        private ColumnComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            int n2 = ((ColumnData)object).getNumber();
            if (n2 < (n = ((ColumnData)object2).getNumber())) {
                return -1;
            }
            if (n2 == n) {
                log.error("Column numbers ('ORDINAL_POSITION') of 2 columns are identical: ", object, object2);
                log.error("Maybe your JDBC driver is buggy. Fix this problem, else the generated code for this table will be BUGGY");
                System.exit(1);
                return 0;
            }
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object);
        }
    }
}

