/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.SystemLog;
import fc.jdbc.dbo.ColumnData;
import fc.jdbc.dbo.Table;
import fc.util.PropertyMgr;
import java.sql.SQLException;

public class Types {
    static final String AVAIL = "available";
    static final String INTMAX = "intmax";
    String PStmt_SetXXX_Length_Param_Type;
    boolean mysqlBooleanHack;
    boolean booleanObjectForNullableBooleans;
    boolean postgresGetObjectToString;
    SystemLog log;

    public Types(SystemLog systemLog, PropertyMgr propertyMgr) {
        this.log = systemLog;
        String string = "dbspecific.mysql.boolean_hack";
        this.mysqlBooleanHack = Boolean.valueOf(propertyMgr.get(string, "true"));
        string = "generate.booleanObjectForNullableBooleans";
        this.booleanObjectForNullableBooleans = Boolean.valueOf(propertyMgr.get(string, "true"));
        string = "dbspecific.postgres.getObjectToString";
        this.postgresGetObjectToString = Boolean.valueOf(propertyMgr.get(string, "true"));
        string = "generate.preparedstatement.setxxx.length_param";
        String string2 = propertyMgr.get(string, AVAIL);
        if (string2 == null) {
            systemLog.warn("Did not understand value for key:", string, " defaulting to using available()");
            this.PStmt_SetXXX_Length_Param_Type = AVAIL;
        } else if ((string2 = string2.toLowerCase().intern()) == INTMAX) {
            this.PStmt_SetXXX_Length_Param_Type = INTMAX;
        } else if (string2 == AVAIL) {
            this.PStmt_SetXXX_Length_Param_Type = AVAIL;
        } else {
            systemLog.warn("Did not understand value for key:", string, "defaulting to using available()");
            this.PStmt_SetXXX_Length_Param_Type = AVAIL;
        }
    }

    public String getResultSetMethod(int n, String string, ColumnData columnData) throws SQLException {
        return this.createMethod("get", n, string, null, null, columnData);
    }

    public String getRuntimeResultSetMethod(int n, String string, ColumnData columnData) throws SQLException {
        return this.createMethod("getruntime", n, string, null, null, columnData);
    }

    public String getPreparedStmtSetMethod(int n, String string, String string2, String string3, ColumnData columnData) throws SQLException {
        return this.createMethod("set", n, string2, string3, string, columnData);
    }

    public String getPreparedStmtSetNullMethod(int n, String string, String string2, ColumnData columnData) throws SQLException {
        return this.createMethod("setNull", n, string, string2, null, columnData);
    }

    private String createMethod(String string, int n, String string2, String string3, String string4, ColumnData columnData) throws SQLException {
        boolean bl = false;
        String string5 = null;
        String string6 = null;
        switch (n) {
            case -6: {
                string6 = this.mysqlBooleanHack ? "Boolean(" : "Byte(";
                break;
            }
            case 5: {
                string6 = "Short(";
                break;
            }
            case 4: {
                string6 = "Int(";
                break;
            }
            case -5: {
                string6 = "Long(";
                break;
            }
            case 6: {
                string6 = "Float(";
                break;
            }
            case 7: {
                string6 = "Float(";
                break;
            }
            case 8: {
                string6 = "Double(";
                break;
            }
            case 3: {
                string6 = "BigDecimal(";
                break;
            }
            case 2: {
                string6 = "BigDecimal(";
                break;
            }
            case 1: {
                string6 = "String(";
                break;
            }
            case 12: {
                string6 = "String(";
                break;
            }
            case -1: {
                string6 = "AsciiStream(";
                bl = true;
                break;
            }
            case 91: {
                string6 = "Date(";
                break;
            }
            case 92: {
                string6 = "Time(";
                break;
            }
            case 93: {
                string6 = "Timestamp(";
                break;
            }
            case 2004: {
                string6 = "Blob(";
                break;
            }
            case 2005: {
                string6 = "Clob(";
                break;
            }
            case -2: {
                string6 = "Bytes(";
                break;
            }
            case -3: {
                string6 = "Bytes(";
                break;
            }
            case -4: {
                string6 = "BinaryStream(";
                bl = true;
                break;
            }
            case 2003: {
                string6 = "Array(";
                break;
            }
            case -7: 
            case 16: {
                string6 = "Boolean(";
                break;
            }
            case 70: {
                this.unsupported(70);
                break;
            }
            case 2001: {
                this.unsupported(2001);
                break;
            }
            case 2000: {
                this.unsupported(2000);
                break;
            }
            case 0: {
                this.unsupported(0);
                break;
            }
            case 1111: {
                columnData.getTable();
                if (Table.generate.isPostgres() && this.postgresGetObjectToString) {
                    string6 = "String(";
                    break;
                }
                string6 = "Object(";
                break;
            }
            case 2006: {
                string6 = "Ref(";
                break;
            }
            case 2002: {
                string6 = "Struct(";
                break;
            }
            default: {
                this.unsupported(n);
            }
        }
        if (string.equals("setNull")) {
            string5 = "setNull(" + string2 + "," + n + ")" + "/*" + this.getSQLTypeName(n) + "*/";
        } else if (string.equals("set")) {
            string5 = "";
            if (bl && this.PStmt_SetXXX_Length_Param_Type.equals(AVAIL)) {
                string5 = string5 + "try { ";
            }
            string5 = columnData.useBooleanObject() ? string5 + string4 + "setObject(" + string2 + ", " + string3 : (n == 1111 ? string5 + string4 + "setObject(" + string2 + ", " + string3 + ", java.sql.Types.OTHER" : string5 + string4 + "set" + string6 + string2 + ", " + string3);
            if (bl) {
                string5 = string5 + ", ";
                if (this.PStmt_SetXXX_Length_Param_Type.equals(AVAIL)) {
                    string5 = string5 + string3 + ".available()";
                } else if (this.PStmt_SetXXX_Length_Param_Type.equals(INTMAX)) {
                    string5 = string5 + "Integer.MAX_VALUE";
                }
            }
            string5 = string5 + "); ";
            if (bl && this.PStmt_SetXXX_Length_Param_Type.equals(AVAIL)) {
                string5 = string5 + "} catch (IOException e) { throw new SQLException(e.toString()); } ";
            }
        } else if (string.equals("get")) {
            string5 = columnData.useBooleanObject() ? "((Boolean) rs.getObject(" + string2 + "))" : "get" + string6 + string2 + ")";
        } else if (string.equals("getruntime")) {
            string5 = columnData.useBooleanObject() ? "((Boolean) rs.getObject(prefix+\"_" + string2 + "\"))" : "get" + string6 + "prefix" + "+\"_" + string2 + "\")";
        } else {
            throw new SQLException("I dont understand how to handle: " + string);
        }
        return string5;
    }

    public String getJavaTypeFromSQLType(int n, ColumnData columnData) throws SQLException {
        boolean bl = columnData.isNullable();
        String string = null;
        switch (n) {
            case -6: {
                string = this.mysqlBooleanHack ? "Boolean" : "byte";
                break;
            }
            case 5: {
                string = "short";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case -5: {
                string = "long";
                break;
            }
            case 6: {
                string = "float";
                break;
            }
            case 7: {
                string = "float";
                break;
            }
            case 8: {
                string = "double";
                break;
            }
            case 3: {
                string = "BigDecimal";
                break;
            }
            case 2: {
                string = "BigDecimal";
                break;
            }
            case 1: {
                string = "String";
                break;
            }
            case 12: {
                string = "String";
                break;
            }
            case -1: {
                string = "InputStream";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "Time";
                break;
            }
            case 93: {
                string = "Timestamp";
                break;
            }
            case 2004: {
                string = "java.sql.Blob";
                break;
            }
            case 2005: {
                string = "java.sql.Clob";
                break;
            }
            case -2: {
                string = "byte[]";
                break;
            }
            case -3: {
                string = "byte[]";
                break;
            }
            case -4: {
                string = "InputStream";
                break;
            }
            case 2003: {
                string = "java.sql.Array";
                break;
            }
            case -7: 
            case 16: {
                if (bl && this.booleanObjectForNullableBooleans) {
                    string = "Boolean";
                    break;
                }
                string = "boolean";
                break;
            }
            case 70: {
                this.unsupported(70);
                break;
            }
            case 2001: {
                this.unsupported(2001);
                break;
            }
            case 2000: {
                this.unsupported(2000);
                break;
            }
            case 0: {
                this.unsupported(0);
                break;
            }
            case 1111: {
                columnData.getTable();
                if (Table.generate.isPostgres() && this.postgresGetObjectToString) {
                    string = "String";
                    break;
                }
                string = "Object";
                break;
            }
            case 2006: {
                string = "java.sql.Ref";
                break;
            }
            case 2002: {
                string = "java.sql.Struct";
                break;
            }
            default: {
                this.unsupported(n);
            }
        }
        return string;
    }

    public boolean usesPrimitiveJavaType(int n, ColumnData columnData) throws SQLException {
        boolean bl = false;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                bl = true;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                bl = true;
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 12: {
                break;
            }
            case -1: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 2004: {
                break;
            }
            case 2005: {
                break;
            }
            case -2: {
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                break;
            }
            case 2003: {
                break;
            }
            case -7: 
            case 16: {
                if (columnData.useBooleanObject()) break;
                bl = true;
                break;
            }
            case 70: {
                this.unsupported(70);
                break;
            }
            case 2001: {
                this.unsupported(2001);
                break;
            }
            case 2000: {
                this.unsupported(2000);
                break;
            }
            case 0: {
                this.unsupported(0);
                break;
            }
            case 1111: {
                bl = false;
                break;
            }
            case 2006: {
                break;
            }
            case 2002: {
                break;
            }
            default: {
                this.unsupported(n);
            }
        }
        return bl;
    }

    public boolean usesSimpleIntegralJavaType(int n) throws SQLException {
        boolean bl = false;
        switch (n) {
            case -5: 
            case 4: {
                bl = true;
            }
        }
        return bl;
    }

    public String getSQLTypeName(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "NOT KNOWN/ERROR";
    }

    void unsupported(int n) throws SQLException {
        throw new SQLException("This framework does not understand/support columns of this type. [java.sql.Type: " + n + "]");
    }
}

