/*
 * Decompiled with CFR 0.152.
 */
package fc.net;

import fc.io.IOUtil;
import fc.util.Args;
import fc.util.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NIC {
    private static boolean dbg = false;
    static String linesep = IOUtil.LINE_SEP;

    public static Map getMAC() {
        Platform platform = Platform.getPlatform();
        try {
            if (platform == Platform.WINDOWS) {
                return NIC.getWindowsMA();
            }
            if (platform == Platform.LINUX) {
                return NIC.getLinuxMA();
            }
            if (platform == Platform.OSX) {
                return NIC.getOSXMA();
            }
            if (platform == Platform.FREEBSD) {
                return NIC.getLinuxMA();
            }
            if (platform == Platform.OPENBSD) {
                return NIC.getLinuxMA();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getWindowsMA() throws IOException {
        HashMap<String, NICInfo> hashMap = new HashMap<String, NICInfo>();
        Process process = Runtime.getRuntime().exec("ipconfig /all");
        InputStream inputStream = process.getInputStream();
        try {
            String string = IOUtil.inputStreamToString(inputStream, true);
            if (dbg) {
                System.out.println("getWindowsMA(): " + linesep + "--------------- result ------------ " + linesep + string + linesep + "--------------------------------");
            }
            Pattern pattern = Pattern.compile("(?i)(?m)(?s)Ethernet\\s+adapter\\s+(.*?):.*?Physical\\s+Address.*?:\\s*([a-zA-Z0-9\\-]*).*?NetBIOS.*?:\\s*\\w*");
            Pattern pattern2 = Pattern.compile("(?i)(?m)IP\\s+Address.*?:\\s+(.+?)$");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                if (dbg) {
                    System.out.println("getWindowsMA(): found: " + matcher.group(0));
                }
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                Matcher matcher2 = pattern2.matcher(matcher.group(0));
                while (matcher2.find()) {
                    String string4 = matcher2.group(1);
                    if (dbg) {
                        System.out.println("ip=" + string4 + "; mac=" + string3 + "; name=" + string2);
                    }
                    NICInfo nICInfo = new NICInfo(string2, string3);
                    hashMap.put(string4, nICInfo);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getLinuxMA() throws IOException {
        HashMap<String, NICInfo> hashMap = new HashMap<String, NICInfo>();
        Process process = Runtime.getRuntime().exec("ifconfig");
        InputStream inputStream = process.getInputStream();
        try {
            String string = IOUtil.inputStreamToString(inputStream, true);
            String string2 = "(?s)(?m)(?i)(eth.*?)\\s+.+?HWaddr\\s([a-zA-Z0-9:\\-]*).*?addr:(.+?)\\s";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                String string5 = matcher.group(3);
                if (dbg) {
                    System.out.println("getLinuxMA(): found: " + matcher.group(0));
                }
                if (dbg) {
                    System.out.println("ip=" + string5 + "; mac=" + string4 + "; name=" + string3);
                }
                NICInfo nICInfo = new NICInfo(string3, string4);
                hashMap.put(string5, nICInfo);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getOSXMA() throws IOException {
        HashMap<String, NICInfo> hashMap = new HashMap<String, NICInfo>();
        Process process = Runtime.getRuntime().exec("ifconfig");
        InputStream inputStream = process.getInputStream();
        try {
            String string = IOUtil.inputStreamToString(inputStream, true);
            String string2 = "(?s)(?m)(?i)(en\\d+):.+?.*?status.*?$";
            Pattern pattern = Pattern.compile(string2);
            Matcher matcher = pattern.matcher(string);
            Pattern pattern2 = Pattern.compile("(?i)inet\\s+([0-9.]+)\\s*");
            Pattern pattern3 = Pattern.compile("(?i)ether\\s+([a-zA-Z0-9:\\-]*)\\s*");
            while (matcher.find()) {
                String string3 = matcher.group(1);
                if (dbg) {
                    System.out.println("\n\n=========found: group[0]===========");
                    System.out.println(matcher.group(0));
                    System.out.println("\n==================");
                }
                String string4 = null;
                String string5 = null;
                Matcher matcher2 = pattern2.matcher(matcher.group(0));
                Matcher matcher3 = pattern3.matcher(matcher.group(0));
                if (matcher2.find()) {
                    string5 = matcher2.group(1);
                }
                if (matcher3.find()) {
                    string4 = matcher3.group(1);
                }
                if (dbg) {
                    System.out.println("ip=" + string5 + "; mac=" + string4 + "; name=" + string3);
                }
                if (string5 == null || string4 == null) continue;
                NICInfo nICInfo = new NICInfo(string3, string4);
                hashMap.put(string5, nICInfo);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return hashMap;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        if (args.flagExists("debug")) {
            dbg = true;
        }
        System.out.println("[1] Mac Addresses: " + NIC.getMAC());
        System.out.println("\n[2] Using java networkinterface methods");
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
        for (int i = 0; i < arrayList.size(); ++i) {
            NetworkInterface networkInterface = (NetworkInterface)arrayList.get(i);
            System.out.println("name=" + networkInterface.getName() + ";ip=" + Collections.list(networkInterface.getInetAddresses()) + ";hw=" + networkInterface.getHardwareAddress() + ";up=" + networkInterface.isUp());
        }
    }

    public static class NICInfo {
        String interfaceName;
        String mac;

        NICInfo(String string, String string2) {
            this.interfaceName = string;
            this.mac = string2;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getMACAddress() {
            return this.mac;
        }

        public String toString() {
            return "[NICInfo: name=" + this.interfaceName + "; MAC=" + this.mac + "]";
        }
    }
}

