/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.util.StringUtil;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import org.json.JSONObject;

public final class ClassUtil {
    static final String nl = IOUtil.LINE_SEP;
    static final boolean dbg = false;

    public static String getClassLoaderInfo(Object object) {
        Argcheck.notnull(object, "specified obj param was null");
        return ClassUtil.getClassLoaderInfo(object.getClass());
    }

    public static String getClassLoaderInfo(Class clazz) {
        ClassLoader classLoader;
        Argcheck.notnull(clazz, "specified class param was null");
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("============== Classloader Information ==================");
        stringBuffer.append(nl);
        stringBuffer.append("System classloader = ");
        stringBuffer.append(ClassLoader.getSystemClassLoader());
        stringBuffer.append(nl);
        Thread thread = Thread.currentThread();
        stringBuffer.append("Current thread = ").append(thread);
        stringBuffer.append(nl);
        stringBuffer.append("Current thread context classloader = ");
        stringBuffer.append(thread.getContextClassLoader());
        stringBuffer.append(nl);
        stringBuffer.append("Class loader hierarchy: ");
        stringBuffer.append(nl);
        stringBuffer.append("[").append(clazz);
        stringBuffer.append("][package:");
        Package package_ = clazz.getPackage();
        stringBuffer.append(package_ != null ? package_.getName() : "N/A");
        stringBuffer.append("]");
        stringBuffer.append("/ClassID:");
        stringBuffer.append(System.identityHashCode(classLoader));
        stringBuffer.append(" loaded by:");
        stringBuffer.append(nl);
        String string = "  ";
        for (classLoader = clazz.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            stringBuffer.append(string);
            stringBuffer.append(classLoader);
            stringBuffer.append(nl);
            string = string + "   ";
        }
        stringBuffer.append(string + "null (bootstrap class loader)");
        stringBuffer.append(nl);
        stringBuffer.append("=========================================================");
        stringBuffer.append(nl);
        return stringBuffer.toString();
    }

    public static String getClassName() {
        return new CurrentClassGetter().getClassName();
    }

    public static String getMainClassName() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - 1];
        String string = stackTraceElement.getClassName();
        return string;
    }

    public static boolean isSystemClass(Class clazz) {
        return clazz.getClassLoader() == null;
    }

    public static String getLoadedFromPath(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        String string = codeSource.getLocation().getPath();
        return string;
    }

    public static String getParentDir(Class clazz) {
        String string = StringUtil.fileName(clazz.getName().replace('.', '/')) + ".class";
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.getProtocol();
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("file")) {
            return StringUtil.dirName(uRL.getFile());
        }
        return null;
    }

    public static URL getParentDirAsURL(Class clazz) {
        String string = StringUtil.fileName(clazz.getName().replace('.', '/')) + ".class";
        URL uRL = clazz.getResource(string);
        String string2 = StringUtil.dirName(uRL.toString());
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (Exception exception) {
            System.err.println(IOUtil.throwableToString(exception));
        }
        return uRL2;
    }

    public static void main(String[] stringArray) {
        System.out.println(ClassUtil.getClassLoaderInfo(ClassUtil.class));
        Class<?> clazz = new Object().getClass();
        System.out.println(ClassUtil.getClassLoaderInfo(clazz));
        System.out.println("getClassName(): " + ClassUtil.getClassName());
        System.out.println("getMainClassName(): " + ClassUtil.getMainClassName());
        System.out.println();
        System.out.println("-------- these should return null --(system classes) ------");
        ClassUtil.test(clazz);
        System.out.println("-------- these should return a value (either jar or directory) ------");
        ClassUtil.test(ClassUtil.class);
        System.out.println("-------- these should return a value (either jar or directory) ------");
        ClassUtil.test(new JSONObject().getClass());
    }

    private static void test(Class clazz) {
        System.out.println(clazz);
        System.out.println("isSystemClass: " + ClassUtil.isSystemClass(clazz));
        System.out.println("getLoadedFromPath: " + ClassUtil.getLoadedFromPath(clazz));
        System.out.println("getParentDir: " + ClassUtil.getParentDir(clazz));
        System.out.println("getParentDirAsURL: " + ClassUtil.getParentDirAsURL(clazz));
        System.out.println();
    }

    private static class CurrentClassGetter
    extends SecurityManager {
        private CurrentClassGetter() {
        }

        public String getClassName() {
            return this.getClassContext()[2].getName();
        }
    }
}

