/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.Range;
import java.util.Calendar;
import java.util.Date;

public class DateRange
extends Range {
    Date start;
    Date end;

    public DateRange(Date date, Date date2) {
        Argcheck.istrue(date.compareTo(date2) <= 0, "end lesser than start in the specified range, start=[" + date + "], end=[" + date2 + "]");
        this.start = date;
        this.end = date2;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean inRange(Date date) {
        boolean bl;
        Argcheck.notnull(date);
        boolean bl2 = bl = date.compareTo(this.start) >= 0 && date.compareTo(this.end) <= 0;
        if (this.negated) {
            return !bl;
        }
        return bl;
    }

    public boolean overlaps(DateRange dateRange) {
        boolean bl;
        Argcheck.notnull(dateRange);
        boolean bl2 = bl = this.inRange(dateRange.getStart()) || this.inRange(dateRange.getEnd());
        if (this.negated) {
            return !bl;
        }
        return bl;
    }

    public void setStart(Date date) {
        Argcheck.notnull(date, "specified argument was null");
        Argcheck.istrue(date.compareTo(this.end) <= 0, "start greater than end date, specified start=[" + date + "], end=[" + this.end + "]");
        this.start = date;
    }

    public void setEnd(Date date) {
        Argcheck.notnull(date, "specified argument was null");
        Argcheck.istrue(date.compareTo(this.start) >= 0, "end lesser than start, start=[" + this.start + "], specified end=[" + date + "]");
        this.end = date;
    }

    public String toString() {
        String string = "DateRange:[";
        if (this.isNegated()) {
            string = string + "^";
        }
        string = string + this.start + "," + this.end + "]";
        return string;
    }

    public static void main(String[] stringArray) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        DateRange dateRange = new DateRange(date2, date);
        System.out.println("constructed range:" + dateRange);
        DateRange.test(dateRange);
        System.out.println();
        DateRange dateRange2 = new DateRange(date2, new Date(date.getTime() - 86400000L));
        System.out.println("r1:" + dateRange + "\n    -- overlaps? --\n" + "r2:" + dateRange2);
        System.out.println();
        System.out.println("r1 overlaps r2 (should be true): " + dateRange.overlaps(dateRange2));
        System.out.println("r2 overlaps r1 (should be true): " + dateRange2.overlaps(dateRange));
        System.out.println("----------------------------------");
        dateRange2 = new DateRange(new Date(date.getTime() + 86400000L), new Date(date.getTime() + 259200000L));
        System.out.println("r1:" + dateRange + "\n    -- overlaps? --\n" + "r2:" + dateRange2);
        System.out.println();
        System.out.println("r1 overlaps r2 (should be false): " + dateRange.overlaps(dateRange2));
        System.out.println("r2 overlaps r1 (should be false): " + dateRange2.overlaps(dateRange));
        System.out.println("----------------------------------");
        dateRange2 = new DateRange(new Date(date2.getTime() - 259200000L), new Date(date2.getTime() - 86400000L));
        System.out.println("r1:" + dateRange + "\n    -- overlaps? --\n" + "r2:" + dateRange2);
        System.out.println();
        System.out.println("r1 overlaps r2 (should be false): " + dateRange.overlaps(dateRange2));
        System.out.println("r2 overlaps r1 (should be false): " + dateRange2.overlaps(dateRange));
        System.out.println("----------------------------------");
    }

    private static void test(DateRange dateRange) {
        Date date = new Date();
        System.out.println("in range: " + date + "=" + dateRange.inRange(date));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -2);
        date = calendar.getTime();
        System.out.println("in range: " + date + "=" + dateRange.inRange(date));
        calendar.add(2, 2);
        calendar.roll(5, false);
        date = calendar.getTime();
        System.out.println("in range: " + date + "=" + dateRange.inRange(date));
    }
}

