/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.DateRange;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateRangeSet {
    DateRange seedRange;
    List union;
    List intersect;

    public DateRangeSet(DateRange dateRange) {
        Argcheck.notnull(dateRange);
        this.seedRange = dateRange;
        this.union = new ArrayList();
        this.intersect = new ArrayList();
    }

    public void union(DateRange dateRange) {
        Argcheck.notnull(dateRange);
        this.union.add(dateRange);
    }

    public void intersection(DateRange dateRange) {
        Argcheck.notnull(dateRange);
        this.intersect.add(dateRange);
    }

    public boolean inRange(Date date) {
        DateRange dateRange;
        int n;
        boolean bl = this.seedRange.inRange(date);
        int n2 = this.union.size();
        for (n = 0; n < n2; ++n) {
            dateRange = (DateRange)this.union.get(n);
            bl = bl || dateRange.inRange(date);
        }
        n2 = this.intersect.size();
        for (n = 0; n < n2; ++n) {
            dateRange = (DateRange)this.intersect.get(n);
            bl = bl && dateRange.inRange(date);
        }
        return bl;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DateRangeSet:[");
        if (this.intersect.size() > 0) {
            stringBuffer.append("(");
        }
        stringBuffer.append(this.seedRange);
        int n2 = this.union.size();
        if (n2 > 0) {
            stringBuffer.append(" || ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.union.get(n).toString());
                if (n >= n2 - 1) continue;
                stringBuffer.append(" || ");
            }
        }
        if ((n2 = this.intersect.size()) > 0) {
            stringBuffer.append(") && ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.intersect.get(n).toString());
                if (n >= n2 - 1) continue;
                stringBuffer.append(" && ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        calendar.add(2, -1);
        Date date3 = calendar.getTime();
        DateRange dateRange = new DateRange(date3, date2);
        calendar.setTime(date);
        calendar.add(2, -3);
        Date date4 = calendar.getTime();
        calendar.setTime(date);
        calendar.add(2, -6);
        Date date5 = calendar.getTime();
        DateRange dateRange2 = new DateRange(date5, date4);
        DateRangeSet dateRangeSet = new DateRangeSet(dateRange);
        dateRangeSet.union(dateRange2);
        System.out.println("constructed: " + dateRangeSet);
        DateRangeSet.test(dateRangeSet);
        calendar.setTime(date);
        calendar.add(2, -4);
        date4 = calendar.getTime();
        calendar.setTime(date);
        calendar.add(2, -5);
        date5 = calendar.getTime();
        dateRange2 = new DateRange(date5, date4);
        dateRangeSet.intersection(dateRange2);
        System.out.println("constructed: " + dateRangeSet);
        DateRangeSet.test(dateRangeSet);
    }

    private static void test(DateRangeSet dateRangeSet) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -5);
        Date date = calendar.getTime();
        System.out.println("in range: " + date + "=" + dateRangeSet.inRange(date));
        calendar.setTime(new Date());
        calendar.add(2, 3);
        date = calendar.getTime();
        System.out.println("in range: " + date + "=" + dateRangeSet.inRange(date));
    }
}

