/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.IOUtil;
import fc.util.PropertyMgr;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class FilePropertyMgr
extends PropertyMgr {
    String myname = this.getClass().getName();
    Properties props = new Properties();
    File propertyFile;

    public FilePropertyMgr(File file) throws IOException {
        this.propertyFile = file;
        try {
            this.props.load(new BufferedInputStream(new FileInputStream(file)));
            this.log.info(this.myname, "; Loaded properties from file: ", file);
            this.log.bug(IOUtil.propertiesToString(this.props));
        }
        catch (IOException iOException) {
            this.log.error("Cannot open file: ", file.getAbsolutePath());
            this.log.error("*** PropertyMgr will not be available ***", iOException);
            throw iOException;
        }
    }

    @Override
    public String get(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            return string2.trim();
        }
        return string2;
    }

    @Override
    public String set(String string, String string2) {
        Object object = this.props.setProperty(string, string2);
        return (String)object;
    }

    @Override
    public void save() throws IOException {
        String string = "Properties saved on: " + new Date();
        this.props.store(new FileOutputStream(this.propertyFile), string);
    }

    public String toString() {
        String string = this.myname + "; contains the following properties: " + IOUtil.LINE_SEP;
        string = string + IOUtil.propertiesToString(this.props);
        string = string + "------------------------";
        return string;
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    private static class Test {
        Test() {
            try {
                class FooFilePropertyMgr
                extends FilePropertyMgr {
                    public FooFilePropertyMgr(String string) throws Exception {
                        super(new File(string));
                    }

                    @Override
                    protected void handleError(String string) {
                        System.out.println("Error: " + string);
                    }
                }
                FilePropertyMgr filePropertyMgr = new FooFilePropertyMgr("./FilePropertyMgr_test.txt");
                System.out.println("got required property 'foo' = " + filePropertyMgr.getRequired("foo"));
                System.out.println("got required property 'abc' = " + filePropertyMgr.getRequired("abc"));
                System.out.println("got required property 'x.y' = " + filePropertyMgr.getRequired("x.y"));
                System.out.println("got required property 'num' = " + filePropertyMgr.getRequiredInt("num"));
                System.out.println("got required property 'bool' = " + filePropertyMgr.getRequiredBoolean("bool"));
                System.out.println("got property 'num2' = " + filePropertyMgr.getInt("num2", 123));
                System.out.println("got property 'bool2' = " + filePropertyMgr.getBoolean("bool2", false));
                System.out.println("Getting bad format properties...");
                System.out.println("got required property 'num3' = " + filePropertyMgr.getRequiredInt("num3"));
                System.out.println("got required property 'bool3' = " + filePropertyMgr.getRequiredBoolean("bool3"));
                System.out.println("got property 'num3' = " + filePropertyMgr.getInt("num3", 123));
                System.out.println("got property 'bool3' = " + filePropertyMgr.getBoolean("bool3", false));
                System.out.println("now calling the FilePropertyMgr.toString()");
                System.out.println(filePropertyMgr.toString());
                System.out.println("The following should exit the test");
                filePropertyMgr = new FilePropertyMgr(new File("./FilePropertyMgr_test.txt"));
                System.out.println("got property 'test.don'texist' = " + filePropertyMgr.getRequired("test.don'texist"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

