/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Args;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageUtil {
    public static void resize(File file, File file2, String string, int n, int n2) throws IOException {
        BufferedImage bufferedImage = ImageUtil.resize(file, n, n2);
        ImageIO.write((RenderedImage)bufferedImage, string, file2);
    }

    public static void resize(File file, File file2, int n, int n2) throws IOException {
        String string = file.getName();
        int n3 = string.lastIndexOf(".");
        if (n3 == -1) {
            throw new IOException("The specified source file: [" + file.getAbsolutePath() + "] has no extension, and this method needs an extension (like .gif, .jpg etc)");
        }
        String string2 = string.substring(n3 + 1, string.length());
        ImageUtil.resize(file, file2, string2, n, n2);
    }

    public static BufferedImage resize(File file, int n, int n2) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n / (double)n3, (double)n2 / (double)n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(bufferedImage, affineTransform, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static void main(String[] stringArray) throws IOException {
        Args args = new Args(stringArray);
        args.setUsage(args.getMainClassName() + " -source path-to-source-image -target path-to-write-target-img -width new-width -height new-height");
        File file = new File(args.getRequired("source"));
        File file2 = new File(args.getRequired("target"));
        int n = args.getRequiredInt("width");
        int n2 = args.getRequiredInt("height");
        if (!file.exists()) {
            System.out.println("Cannot read source file: " + file.getAbsolutePath());
            System.exit(1);
        }
        ImageUtil.resize(file, file2, n, n2);
    }
}

