/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.Range;

public class NumberRange
extends Range {
    long start;
    long end;

    public NumberRange(long l, long l2) {
        Argcheck.istrue(l <= l2, "end number lesser than start number in the specified range, start=[" + l + "], end=[" + l2 + "]");
        this.start = l;
        this.end = l2;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean inRange(long l) {
        boolean bl;
        boolean bl2 = bl = l >= this.start && l <= this.end;
        if (this.negated) {
            return !bl;
        }
        return bl;
    }

    public void setEnd(long l) {
        Argcheck.istrue(this.start <= l, "end number lesser than start number in the specified range, start=[" + this.start + "], specified end=[" + l + "]");
        this.end = l;
    }

    public void setStart(long l) {
        Argcheck.istrue(l <= this.end, "start number greater than end number in the specified range, end=[" + this.end + "], specified start=[" + l + "]");
        this.start = l;
    }

    public long getSize() {
        return this.end - this.start + 1L;
    }

    public String toString() {
        String string = "NumberRange:[";
        if (this.isNegated()) {
            string = string + "^";
        }
        string = this.start >= 0L ? string + this.start : string + "(" + this.start + ")";
        string = string + "<->";
        string = this.end >= 0L ? string + this.end : string + "(" + this.end + ")";
        string = string + "]";
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NumberRange)) {
            return false;
        }
        NumberRange numberRange = (NumberRange)object;
        return this.start == numberRange.start && this.end == numberRange.end;
    }

    public int hashCode() {
        return (int)this.getSize();
    }

    public static void main(String[] stringArray) {
        NumberRange numberRange = new NumberRange(-10L, 10L);
        System.out.println("constructed range:" + numberRange);
        System.out.println("Range size=" + numberRange.getSize());
        NumberRange numberRange2 = new NumberRange(-10L, 10L);
        System.out.println("Constructed range2=" + numberRange2);
        NumberRange numberRange3 = new NumberRange(-10L, 9L);
        System.out.println("Constructed range3=" + numberRange3);
        System.out.println("");
        System.out.println("r.equals(r2)=" + numberRange.equals(numberRange2));
        System.out.println("r.equals(r3)=" + numberRange.equals(numberRange3));
        System.out.println("r.hashCode=" + numberRange.hashCode());
        System.out.println("r2.hashCode=" + numberRange2.hashCode());
        System.out.println("r3.hashCode=" + numberRange3.hashCode());
        NumberRange.test(numberRange);
        numberRange.setNegated(true);
        System.out.println("setting the range to be negated:" + numberRange);
        NumberRange.test(numberRange);
        System.out.println("the following should throw an exception");
        numberRange = new NumberRange(5L, 0L);
    }

    private static void test(NumberRange numberRange) {
        System.out.println("0 in range:" + numberRange.inRange(0L));
        System.out.println("1 in range:" + numberRange.inRange(1L));
        System.out.println("10 in range:" + numberRange.inRange(10L));
        System.out.println("11 in range:" + numberRange.inRange(11L));
        System.out.println("-1 in range:" + numberRange.inRange(-1L));
        System.out.println("-10 in range:" + numberRange.inRange(-10L));
        System.out.println("-11 in range:" + numberRange.inRange(-11L));
    }
}

