/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.Log;
import fc.util.PropertyNotFoundException;
import java.io.IOException;

public abstract class PropertyMgr {
    protected String usage;
    protected Log log = Log.getDefault();

    public abstract String get(String var1);

    public String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string);
        if (string2 == null) {
            return bl;
        }
        return this.toBoolean(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.warn("Cannot convert property '" + string + "', into a number, returning backup value " + n);
            }
        }
        return n;
    }

    public String getRequired(String string) {
        String string2 = this.get(string);
        if (string2 == null || string2.trim().length() == 0) {
            try {
                this.handleError(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return string2;
    }

    public boolean getRequiredBoolean(String string) {
        String string2 = this.getRequired(string);
        return this.toBoolean(string2);
    }

    public int getRequiredInt(String string) {
        String string2 = this.getRequired(string);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warn("Cannot convert property '" + string + "', into a number");
            try {
                this.handleError(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return n;
    }

    public abstract String set(String var1, String var2);

    public abstract void save() throws IOException;

    public void setUsage(String string) {
        this.usage = string;
    }

    protected void handleError(String string) throws PropertyNotFoundException {
        this.log.error("Application is missing required Property: " + string);
        new Exception().printStackTrace(System.err);
        if (this.usage != null) {
            this.log.error(this.usage);
        }
        System.exit(1);
    }

    final boolean toBoolean(String string) {
        return (string = string.trim().toLowerCase().intern()) == "true" || string == "yes" || string == "1";
    }
}

