/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.util.CustomCode;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Template {
    private boolean dbg = false;
    private int approx_len;
    static final String dolsign = "{dolsign}";
    Map datamap;
    List template_actions;
    Pattern namepat;
    static HashMap loadedclasses = new HashMap();

    public Template(File file) throws IOException {
        Argcheck.notnull(file, this.getClass().getName() + ":<init> specified templatefile parameter was null");
        String string = file.getAbsolutePath();
        String string2 = IOUtil.fileToString(string);
        if (string2 == null) {
            throw new IOException("The template file: " + string + " could not be read");
        }
        this.doInit(string2);
    }

    public Template(String string) throws IOException {
        Argcheck.notnull(string, this.getClass().getName() + ":<init> specified template parameter was null");
        this.doInit(string);
    }

    private void doInit(String string) throws IOException {
        this.namepat = Pattern.compile("(\\$(?!code)([a-zA-Z](?:\\w|-)*))|(\\$code\\s*\\(\\s*([^\\s]+)\\s*\\))", 2);
        this.datamap = new HashMap();
        this.template_actions = new ArrayList();
        Matcher matcher = this.namepat.matcher(string);
        int n = 0;
        int n2 = string.length();
        while (matcher.find()) {
            int n3;
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            String string5 = matcher.group(4);
            if (this.dbg) {
                System.out.println("found, begin:" + matcher.group() + ",g1=" + string2 + ", g2=" + string3 + ", g3=" + string4 + ", g4=" + string5);
            }
            if (string2 != null && string4 != null || string2 == null && string4 == null) {
                throw new IOException("Error parsing template file, found input I don't understand:" + matcher.group());
            }
            if (string2 != null) {
                n3 = matcher.start(1);
                if (this.dbg) {
                    System.out.println("g1:" + n + "," + n3);
                }
                this.template_actions.add(new Text(string.substring(n, n3)));
                this.template_actions.add(new Var(string3));
                n = matcher.end(1);
                if (!this.dbg) continue;
                System.out.println("finished g1");
                continue;
            }
            if (string4 == null) continue;
            n3 = matcher.start(3);
            if (this.dbg) {
                System.out.println("g3:" + n + "," + n3);
            }
            this.template_actions.add(new Text(string.substring(n, n3)));
            this.template_actions.add(new Code(string5));
            n = matcher.end(3);
            if (!this.dbg) continue;
            System.out.println("finished g3");
        }
        if (n != n2) {
            this.template_actions.add(new Text(string.substring(n, n2)));
        }
        this.approx_len = string.length() * 2;
        if (this.dbg) {
            System.out.println("template_actions = " + this.template_actions);
        }
    }

    public Map getTemplateData() {
        return this.datamap;
    }

    public void reset() {
        this.datamap.clear();
    }

    public void set(String string, String string2) {
        if (!this.checkNameSyntax(string)) {
            throw new IllegalArgumentException("Template variable name " + string + " is not syntactically valid (when specifying variable names, *include* the \"$\" sign!)");
        }
        this.datamap.put(string, string2);
    }

    public void fill(String string, String string2) {
        this.set(string, string2);
    }

    public void fill(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public void fill(String string, long l) {
        this.set(string, String.valueOf(l));
    }

    public void fill(String string, boolean bl) {
        this.set(string, String.valueOf(bl));
    }

    public void fill(String string, Object object) {
        this.set(string, String.valueOf(object));
    }

    public void write(File file) throws IOException {
        this.write(file, true);
    }

    public void write(File file, boolean bl) throws IOException {
        Argcheck.notnull(file);
        if (file.exists()) {
            if (!bl) {
                return;
            }
            if (!file.isFile()) {
                throw new IOException("Specified file: " + file + " is not a regular file");
            }
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        this.mergeWrite(bufferedWriter);
    }

    public void write(Writer writer) throws IOException {
        this.mergeWrite(writer);
    }

    public void write(PrintStream printStream) throws IOException {
        this.mergeWrite(new PrintWriter(printStream));
    }

    public String value() throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter(this.approx_len);
        this.mergeWrite(new PrintWriter(charArrayWriter));
        return charArrayWriter.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.approx_len);
        for (int i = 0; i < this.template_actions.size(); ++i) {
            TemplateAction templateAction = (TemplateAction)this.template_actions.get(i);
            if (templateAction instanceof Text) {
                stringBuilder.append(((Text)templateAction).value);
                continue;
            }
            if (templateAction instanceof Var) {
                Object v = this.datamap.get("$" + ((Var)templateAction).varname);
                stringBuilder.append("[$" + ((Var)templateAction).varname);
                stringBuilder.append("]-->[");
                stringBuilder.append(v);
                stringBuilder.append("]");
                continue;
            }
            if (!(templateAction instanceof Code)) continue;
            stringBuilder.append("Classname:[");
            stringBuilder.append(((Code)templateAction).classname);
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    protected boolean checkNameSyntax(String string) {
        return this.namepat.matcher(string).matches();
    }

    protected void mergeWrite(Writer writer) throws IOException {
        if (this.dbg) {
            System.out.println("using datamap = " + this.datamap);
        }
        Iterator iterator = this.template_actions.iterator();
        while (iterator.hasNext()) {
            ((TemplateAction)iterator.next()).write(writer);
        }
        writer.close();
    }

    public static void main(String[] stringArray) throws Exception {
        new Test(stringArray);
    }

    private static class Test {
        Test(String[] stringArray) throws Exception {
            String string = "test-template.txt";
            String string2 = "template-merged.txt";
            System.out.println("Running test using template file: " + string);
            File file = new File(string);
            Template template = new Template(file);
            template.set("$a", "a-value");
            template.set("$b", "b-value");
            template.set("$c", "c-value");
            template.write(new File(string2));
            System.out.println("Completed. Results in: " + string2);
        }
    }

    class Code
    extends TemplateAction {
        String classname;

        public Code(String string) {
            try {
                Class<?> clazz;
                if (!loadedclasses.containsKey(string) && (clazz = Class.forName(string)) != null) {
                    if (!CustomCode.class.isAssignableFrom(clazz)) {
                        return;
                    }
                    loadedclasses.put(string, clazz.newInstance());
                }
                this.classname = string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void write(Writer writer) throws IOException {
            Object v = loadedclasses.get(this.classname);
            if (v != null) {
                ((CustomCode)v).code(writer, Template.this);
            }
        }

        public String toString() {
            return "CustomClass: " + this.classname;
        }
    }

    class Var
    extends TemplateAction {
        String varname;

        public Var(String string) {
            this.varname = string;
        }

        @Override
        public void write(Writer writer) throws IOException {
            Object v = Template.this.datamap.get("$" + this.varname);
            writer.write(v != null ? (String)v : "");
        }

        public String toString() {
            return "Var:" + this.varname;
        }
    }

    class Text
    extends TemplateAction {
        String value;

        public Text(String string) {
            this.value = string;
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(this.value);
        }

        public String toString() {
            return "Text:" + this.value;
        }
    }

    abstract class TemplateAction {
        TemplateAction() {
        }

        public abstract void write(Writer var1) throws IOException;
    }
}

