/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.NanoWatch;
import fc.util.Watch;
import java.text.DateFormat;
import java.text.NumberFormat;

public final class ThreadLocalDateFormat {
    private final ThreadLocal tldf = new ThreadLocal();

    public DateFormat get() {
        return (DateFormat)this.tldf.get();
    }

    public void set(DateFormat dateFormat) {
        this.tldf.set(dateFormat);
    }

    public boolean isNull() {
        return this.tldf.get() == null;
    }

    public static void main(String[] stringArray) throws Exception {
        ThreadLocalDateFormat threadLocalDateFormat = new ThreadLocalDateFormat();
        TestThread testThread = new TestThread(false, threadLocalDateFormat);
        TestThread testThread2 = new TestThread(false, threadLocalDateFormat);
        testThread.start();
        testThread2.start();
        for (int i = 0; i < 100; ++i) {
            new TestThread(true, threadLocalDateFormat).start();
        }
    }

    static class TestThread
    extends Thread {
        boolean timing_only = false;
        ThreadLocalDateFormat df;

        TestThread(boolean bl, ThreadLocalDateFormat threadLocalDateFormat) {
            this.timing_only = bl;
            this.df = threadLocalDateFormat;
        }

        @Override
        public void run() {
            if (this.df.isNull()) {
                this.df.set(DateFormat.getInstance());
            }
            NanoWatch nanoWatch = new NanoWatch();
            ((Watch)nanoWatch).start();
            if (this.df.isNull()) {
                this.df.set(DateFormat.getInstance());
            }
            DateFormat dateFormat = this.df.get();
            ((Watch)nanoWatch).stop();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            if (this.timing_only) {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]");
            } else {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]" + Thread.currentThread() + "/DateFormat-ID:[" + System.identityHashCode(dateFormat) + "] " + dateFormat);
            }
        }
    }
}

