/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.NanoWatch;
import fc.util.Watch;
import java.text.NumberFormat;

public final class ThreadLocalNumberFormat {
    private final ThreadLocal tlnf = new ThreadLocal();

    public NumberFormat get() {
        return (NumberFormat)this.tlnf.get();
    }

    public void set(NumberFormat numberFormat) {
        this.tlnf.set(numberFormat);
    }

    public boolean isNull() {
        return this.tlnf.get() == null;
    }

    public static void main(String[] stringArray) throws Exception {
        ThreadLocalNumberFormat threadLocalNumberFormat = new ThreadLocalNumberFormat();
        TestThread testThread = new TestThread(false, threadLocalNumberFormat);
        TestThread testThread2 = new TestThread(false, threadLocalNumberFormat);
        testThread.start();
        testThread2.start();
        for (int i = 0; i < 100; ++i) {
            new TestThread(true, threadLocalNumberFormat).start();
        }
    }

    static class TestThread
    extends Thread {
        boolean timing_only = false;
        ThreadLocalNumberFormat nf;

        TestThread(boolean bl, ThreadLocalNumberFormat threadLocalNumberFormat) {
            this.timing_only = bl;
            this.nf = threadLocalNumberFormat;
        }

        @Override
        public void run() {
            if (this.nf.isNull()) {
                this.nf.set(NumberFormat.getInstance());
            }
            NanoWatch nanoWatch = new NanoWatch();
            ((Watch)nanoWatch).start();
            if (this.nf.isNull()) {
                this.nf.set(NumberFormat.getInstance());
            }
            NumberFormat numberFormat = this.nf.get();
            ((Watch)nanoWatch).stop();
            NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
            numberFormat2.setMinimumFractionDigits(2);
            numberFormat2.setMaximumFractionDigits(2);
            numberFormat2.setMinimumIntegerDigits(2);
            if (this.timing_only) {
                System.out.println("ThreadLocal get: [" + numberFormat2.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]");
            } else {
                System.out.println("[" + numberFormat2.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]" + Thread.currentThread() + "/NumberFormat-ID:[" + System.identityHashCode(numberFormat) + "] " + numberFormat);
            }
        }
    }
}

