/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.NanoWatch;
import fc.util.Watch;
import java.text.NumberFormat;
import java.util.Random;

public final class ThreadLocalRandom {
    private final ThreadLocal tlrand = new ThreadLocal();

    public Random get() {
        return (Random)this.tlrand.get();
    }

    public void set(Random random) {
        this.tlrand.set(random);
    }

    public boolean isNull() {
        return this.tlrand.get() == null;
    }

    public static void main(String[] stringArray) throws Exception {
        ThreadLocalRandom threadLocalRandom = new ThreadLocalRandom();
        TestThread testThread = new TestThread(false, threadLocalRandom);
        TestThread testThread2 = new TestThread(false, threadLocalRandom);
        testThread.start();
        testThread2.start();
        for (int i = 0; i < 100; ++i) {
            new TestThread(true, threadLocalRandom).start();
        }
    }

    static class TestThread
    extends Thread {
        boolean timing_only = false;
        ThreadLocalRandom rand;

        TestThread(boolean bl, ThreadLocalRandom threadLocalRandom) {
            this.timing_only = bl;
            this.rand = threadLocalRandom;
        }

        @Override
        public void run() {
            if (this.rand.isNull()) {
                this.rand.set(new Random());
            }
            NanoWatch nanoWatch = new NanoWatch();
            ((Watch)nanoWatch).start();
            if (this.rand.isNull()) {
                this.rand.set(new Random());
            }
            Random random = this.rand.get();
            ((Watch)nanoWatch).stop();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            if (this.timing_only) {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]");
            } else {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]" + Thread.currentThread() + "/Calendar-ID:[" + System.identityHashCode(random) + "] " + random);
            }
        }
    }
}

