/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ToString {
    private static final boolean dbg = false;
    private static Style defaultStyle = new Style();
    Object client;
    Style style;
    StringBuffer result;
    boolean firstFieldDone;

    public ToString(Object object) {
        this(object, (Style)null);
    }

    public ToString(Object object, Style style) {
        Argcheck.notnull(object, "target object cannot be null");
        this.client = object;
        this.style = style == null ? defaultStyle : style;
        this.result = new StringBuffer();
    }

    public ToString(Object object, Style.VisibleLevel visibleLevel) {
        Argcheck.notnull(object, "target object cannot be null");
        this.client = object;
        this.style = defaultStyle;
        this.style.reflectVisibleLevel = visibleLevel;
        this.result = new StringBuffer();
    }

    public static Style getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(Style style) {
        Argcheck.notnull(style, "style cannot be null");
        defaultStyle = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public StringBuffer getBuffer() {
        return this.result;
    }

    public ToString reflect() {
        try {
            this.reflectImpl(this.client, this.client.getClass());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.result.append("Cannot convert to string using reflection");
            this.result.append(illegalAccessException.toString());
        }
        return this;
    }

    void reflectImpl(Object object, Class clazz) throws IllegalAccessException {
        Class clazz2;
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        Field.setAccessible(accessibleObjectArray, true);
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            boolean bl;
            AccessibleObject accessibleObject = accessibleObjectArray[i];
            int n = ((Field)accessibleObject).getModifiers();
            if (!this.style.reflectStatics && Modifier.isStatic(n)) continue;
            boolean bl2 = bl = !Modifier.isPublic(n) && !Modifier.isProtected(n) && !Modifier.isPrivate(n);
            if (this.style.ignoredFieldNames.contains(((Field)accessibleObject).getName().toLowerCase())) continue;
            if (this.style.reflectVisibleLevel == Style.VisibleLevel.PUBLIC) {
                if (!Modifier.isPublic(n)) continue;
                this.append(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(object));
                continue;
            }
            if (this.style.reflectVisibleLevel == Style.VisibleLevel.PROTECTED) {
                if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                this.append(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(object));
                continue;
            }
            if (this.style.reflectVisibleLevel == Style.VisibleLevel.DEFAULT) {
                if (!Modifier.isPublic(n) && !Modifier.isProtected(n) && !bl) continue;
                this.append(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(object));
                continue;
            }
            if (this.style.reflectVisibleLevel == Style.VisibleLevel.PRIVATE) {
                if (!Modifier.isPublic(n) && !Modifier.isProtected(n) && !Modifier.isPrivate(n) && !bl) continue;
                this.append(((Field)accessibleObject).getName(), ((Field)accessibleObject).get(object));
                continue;
            }
            System.out.println("ERROR in ToString().reflecImpl(), this should not happen, toString won't be accurate");
        }
        if (this.style.reflectSuperClass && (clazz2 = clazz.getSuperclass()) != null && clazz2 != Object.class) {
            this.reflectImpl(object, clazz2);
        }
    }

    void doStart(StringBuffer stringBuffer) {
        stringBuffer.append(this.style.startString);
        Class<?> clazz = this.client.getClass();
        String string = clazz.getName();
        if (this.style.className) {
            if (this.style.fullClassName) {
                stringBuffer.append(string);
            } else {
                int n = string.lastIndexOf(".");
                n = n < 0 ? 0 : n + 1;
                stringBuffer.append(string.substring(n, string.length()));
            }
        }
        if (this.style.idHashCode) {
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this.client));
        }
        stringBuffer.append(this.style.startContent);
    }

    void doEnd(StringBuffer stringBuffer) {
        stringBuffer.append(this.style.endContent);
        stringBuffer.append(this.style.endString);
    }

    public String render() {
        StringBuffer stringBuffer = new StringBuffer(this.result.length() + 128);
        this.doStart(stringBuffer);
        stringBuffer.append(this.result);
        this.doEnd(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + "; using: " + this.style;
    }

    public static void main(String[] stringArray) {
        System.out.println("=== Test using reflection ===");
        Style style = null;
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.PUBLIC;
        style.reflectStatics = true;
        System.out.println("public fields [including statics]");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.PUBLIC;
        System.out.println("public fields only");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.PUBLIC;
        style.idHashCode = false;
        style.className = false;
        System.out.println("public fields only, no id ref or class name");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.PROTECTED;
        System.out.println("protected and higher");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectStatics = true;
        style.reflectVisibleLevel = Style.VisibleLevel.DEFAULT;
        System.out.println("package and higher [including statics]");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.DEFAULT;
        style.expandArrays = true;
        System.out.println("package and higher fields, arrays EXPANDED");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        style.reflectVisibleLevel = Style.VisibleLevel.PRIVATE;
        System.out.println("private (all) fields");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        style = new Style();
        style.ignoreFieldName("style");
        System.out.println("default style output");
        System.out.println(new TestClass(style, true));
        System.out.println("");
        System.out.println("==== Test without reflection ====");
        style = new Style();
        System.out.println(new TestClass(style, false));
        System.out.println("");
        System.out.println("With no field names");
        style = new Style();
        style.fieldName = false;
        System.out.println(new TestClass(style, false));
        System.out.println("");
        style = new Style();
        style.reflectVisibleLevel = Style.VisibleLevel.DEFAULT;
        style.expandArrays = true;
        System.out.println("Expanded arrays");
        System.out.println(new TestClass(style, false));
        System.out.println("");
    }

    public ToString append(Object object) {
        this.result.append(object);
        return this;
    }

    public ToString append(String string, Object object) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(object);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, String string2) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(string2);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, long l) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(l);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, int n) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(n);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, short s) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(s);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, byte by) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(by);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, double d) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(d);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, float f) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(f);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, char c) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(c);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, boolean bl) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        this.result.append(bl);
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, Object[] objectArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(objectArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(objectArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, long[] lArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < lArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(lArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(lArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, int[] nArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < nArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(nArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(nArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, short[] sArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < sArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(sArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(sArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, byte[] byArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < byArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(byArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(byArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, char[] cArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < cArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(cArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(cArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, double[] dArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < dArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(dArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(dArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, float[] fArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < fArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(fArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(fArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public ToString append(String string, boolean[] blArray) {
        if (this.firstFieldDone) {
            this.result.append(this.style.fieldSep);
        }
        if (this.style.fieldName) {
            this.result.append(string);
            this.result.append(this.style.fieldAndValSep);
        }
        if (this.style.expandArrays) {
            this.result.append(this.style.startArray);
            for (int i = 0; i < blArray.length; ++i) {
                if (i != 0) {
                    this.result.append(this.style.arrayValSep);
                }
                this.result.append(blArray[i]);
            }
            this.result.append(this.style.endArray);
        } else {
            this.result.append(blArray);
        }
        this.firstFieldDone = true;
        return this;
    }

    public static class Style {
        private List ignoredFieldNames = new ArrayList();
        public String startString = "";
        public String endString = "";
        public String startContent = "[";
        public String endContent = "]";
        public String fieldAndValSep = "=";
        public String fieldSep = ", ";
        public String startArray = "{";
        public String endArray = "}";
        public String arrayValSep = ",";
        public boolean expandArrays = false;
        public boolean fieldName = true;
        public boolean className = true;
        public boolean fullClassName = false;
        public boolean idHashCode = true;
        public boolean reflectFieldName = true;
        public boolean reflectSuperClass = false;
        public boolean reflectStatics = false;
        public VisibleLevel reflectVisibleLevel = VisibleLevel.PRIVATE;

        public void ignoreFieldName(String string) {
            this.ignoredFieldNames.add(string.toLowerCase());
        }

        public String toString() {
            return new ToString(this).reflect().render();
        }

        public static final class VisibleLevel {
            public static VisibleLevel PUBLIC = new VisibleLevel();
            public static VisibleLevel PROTECTED = new VisibleLevel();
            public static VisibleLevel DEFAULT = new VisibleLevel();
            public static VisibleLevel PRIVATE = new VisibleLevel();

            private VisibleLevel() {
            }
        }
    }

    private static class TestClass {
        private Style style;
        private boolean useReflection;
        static int staticInt = 10;
        public static String staticString = "staticString";
        public String pubString = "publicString";
        protected String protectedString = "protectedString";
        String defString = "defaultString";
        int[] intArray = new int[]{1, 2, 3};
        double[] doubleArray = new double[]{1.3, 2.6, 3.9};
        Object[] objectArray = new Object[]{null, new Object()};
        List someList = new ArrayList();
        private String privateString = "privateStrng";

        TestClass(Style style, boolean bl) {
            this.style = style;
            this.useReflection = bl;
        }

        public String toString() {
            if (this.useReflection) {
                return new ToString((Object)this, this.style).reflect().render();
            }
            return new ToString((Object)this, this.style).append("intArray", this.intArray).append("doubleArray", this.doubleArray).append("pubString", this.pubString).render();
        }
    }
}

