/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.Queue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class Tree {
    private static final boolean dbg = false;
    String name;
    Node root;

    public Tree() {
        this(null);
    }

    public Tree(String string) {
        this.name = string;
    }

    public Node createRootNode(Object object) {
        this.root = new Node(object);
        return this.root;
    }

    public Node getRootNode() {
        return this.root;
    }

    public String toString() {
        return this.name + "; maximum depth=" + this.root.getMaxDepth() + "; total # of nodes=" + this.root.recursiveSize();
    }

    public static void main(String[] stringArray) throws Exception {
        Tree tree = new Tree("My_Test_Tree");
        Node node = tree.createRootNode("1");
        Node node2 = new Node(node, "2");
        Node node3 = new Node(node2, "3");
        node3 = new Node(node2, "4");
        node2 = new Node(node, "5");
        node3 = new Node(node2, "6");
        System.out.println("Tree=" + tree);
        Tree.iterateTest(node);
        Tree.structTest(node);
        node = tree.createRootNode("1");
        node3 = new Node("2");
        Node node4 = new Node("3");
        Node node5 = new Node("4");
        node.add(node3);
        node3.add(node4);
        node4.add(node5);
        System.out.println("Tree=" + tree);
        System.out.println("Note: when a node has only 1 child, in-order should print the parent before that child");
        Tree.iterateTest(node);
        node = tree.createRootNode("1");
        node3 = new Node("2");
        node4 = new Node("3");
        node5 = new Node("4");
        node.add(node3);
        node.add(node4);
        node.add(node5);
        System.out.println("Tree=" + tree);
        Tree.iterateTest(node);
    }

    private static void iterateTest(Node node) {
        Node node2;
        Iterator iterator = null;
        System.out.print("Breadth First iteration: ");
        iterator = node.iterator(IterationOrder.BreadthFirst);
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            System.out.print(node2 + " ");
        }
        System.out.println("");
        System.out.print("PreOrder iteration: ");
        iterator = node.iterator(IterationOrder.PreOrder);
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            System.out.print(node2 + " ");
        }
        System.out.println("");
        try {
            System.out.print("InOrderIteration: ");
            iterator = node.iterator(IterationOrder.InOrder);
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                System.out.print(node2 + " ");
            }
            System.out.println("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.print("PostOrder iteration: ");
        iterator = node.iterator(IterationOrder.PostOrder);
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            System.out.print(node2 + " ");
        }
        System.out.println("");
        System.out.println("");
    }

    private static void structTest(Node node) {
        System.out.println("PreOrder iteration, methods test");
        Iterator iterator = node.iterator(IterationOrder.PreOrder);
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            System.out.print(node2);
            System.out.print(" ; isRoot=" + node2.isRoot());
            System.out.print(" ; isleaf=" + node2.isLeaf());
            System.out.print(" ; level=" + node2.getLevel());
            System.out.print(" ; data=" + node2.getData());
            System.out.print(" ; maxdepth=" + node2.getMaxDepth());
            System.out.print(" ; parent=" + node2.getParent());
            System.out.print(" ; siblings=");
            Tree.printIterator(node2.getSiblings());
            System.out.println("");
        }
        System.out.println("");
    }

    private static void printIterator(Iterator iterator) {
        if (iterator == null) {
            System.out.print(iterator);
        } else {
            while (iterator.hasNext()) {
                System.out.print(iterator.next());
            }
        }
    }

    private static class InOrderIterator
    implements Iterator {
        Node startnode;
        Queue q;
        Iterator child_it;

        InOrderIterator(Node node) {
            Iterator iterator;
            Argcheck.notnull(node, "specified node was null");
            List list = node.children;
            int n = list.size();
            if (n > 2) {
                throw new IllegalArgumentException("This iterator only supports 2 children per node. Encountered node has children = " + list);
            }
            this.q = new Queue();
            this.startnode = node;
            if (n == 2) {
                this.q.enque(list.get(0));
                this.q.enque(node);
                this.q.enque(list.get(1));
            } else if (n == 1) {
                this.q.enque(node);
                this.q.enque(list.get(0));
            } else {
                this.q.enque(node);
            }
            this.child_it = iterator = new ArrayList().iterator();
        }

        @Override
        public boolean hasNext() {
            return !this.q.empty() || this.child_it.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            if (this.child_it.hasNext()) {
                Object e = this.child_it.next();
                return e;
            }
            Node node = (Node)this.q.deque();
            if (node == this.startnode) {
                return node;
            }
            this.child_it = new InOrderIterator(node);
            Object e = this.child_it.next();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class PostOrderIterator
    implements Iterator {
        Node startnode;
        Stack childstack;
        Iterator child_it;

        PostOrderIterator(Node node) {
            Object object;
            Argcheck.notnull(node, "specified node was null");
            this.childstack = new Stack();
            this.startnode = node;
            if (!node.isLeaf()) {
                object = node.children;
                ListIterator listIterator = object.listIterator(object.size());
                while (listIterator.hasPrevious()) {
                    Node node2 = (Node)listIterator.previous();
                    this.childstack.push(node2);
                }
            }
            this.child_it = object = new ArrayList().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.startnode != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            if (this.child_it.hasNext()) {
                Object e = this.child_it.next();
                return e;
            }
            if (!this.childstack.empty()) {
                this.child_it = new PostOrderIterator((Node)this.childstack.pop());
                Object e = this.child_it.next();
                return e;
            }
            Node node = this.startnode;
            this.startnode = null;
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class PreOrderIterator
    implements Iterator {
        Stack stack;

        PreOrderIterator(Node node) {
            Argcheck.notnull(node, "specified node was null");
            this.stack = new Stack();
            this.stack.push(node);
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            Node node = (Node)this.stack.pop();
            List list = node.children;
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Node node2 = (Node)listIterator.previous();
                this.stack.push(node2);
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static class BreadthFirstIterator
    implements Iterator {
        Queue q = new Queue();

        BreadthFirstIterator(Node node) {
            this.q.enque(node);
        }

        @Override
        public boolean hasNext() {
            return !this.q.empty();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            Node node = (Node)this.q.deque();
            if (!node.isLeaf()) {
                this.q.addAll(node.getChildren());
            }
            return node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public static abstract class IterationOrder {
        public static final IterationOrder BreadthFirst = new IterationOrder(){

            @Override
            public Iterator iterator(Node node) {
                return new BreadthFirstIterator(node);
            }
        };
        public static final IterationOrder PreOrder = new IterationOrder(){

            @Override
            public Iterator iterator(Node node) {
                return new PreOrderIterator(node);
            }
        };
        public static final IterationOrder InOrder = new IterationOrder(){

            @Override
            public Iterator iterator(Node node) {
                return new InOrderIterator(node);
            }
        };
        public static final IterationOrder PostOrder = new IterationOrder(){

            @Override
            public Iterator iterator(Node node) {
                return new PostOrderIterator(node);
            }
        };

        private IterationOrder() {
        }

        public abstract Iterator iterator(Node var1);
    }

    public static class Node {
        Node parent;
        List children;
        Object data;

        public Node(Object object) {
            this(null, object);
        }

        public Node(Node node, Object object) {
            this.parent = node;
            this.data = object;
            this.children = new ArrayList();
            if (node != null) {
                node.add(this);
            }
        }

        public void add(Node node) {
            this.children.add(node);
        }

        public boolean remove(Node node) {
            return this.children.remove(node);
        }

        public List getChildren() {
            return this.children;
        }

        public Node getChildContaining(Object object) {
            if (this.children == null) {
                return null;
            }
            Node node = null;
            for (Node node2 : this.children) {
                Object object2 = node2.data;
                if (object2 == null || !object2.equals(object)) continue;
                node = node2;
                break;
            }
            return node;
        }

        public boolean containsChild(Node node) {
            return this.children.contains(node);
        }

        public Node getParent() {
            return this.parent;
        }

        public Iterator getSiblings() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (this.parent == null) {
                return arrayList.iterator();
            }
            Node node = this.getParent();
            for (Node node2 : node.children) {
                if (node2 == this) continue;
                arrayList.add(node2);
            }
            return arrayList.iterator();
        }

        public Object getData() {
            return this.data;
        }

        public int recursiveSize() {
            int n = 1;
            for (Node node : this.children) {
                n += node.recursiveSize();
            }
            return n;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isNodeAncestor(Node node) {
            if (node == this) {
                return false;
            }
            boolean bl = false;
            Node node2 = this.parent;
            while (node2 != null) {
                if (!(node2 = node2.getParent()).equals(node)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public boolean isNodeChild(Node node) {
            return this.children.contains(node);
        }

        public boolean isNodeDescendant(Node node) {
            return node.isNodeAncestor(this);
        }

        public boolean isNodeSibling(Node node) {
            return node != this && this.parent.children.contains(node);
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public int getLevel() {
            int n = 0;
            Node node = this.parent;
            while (node != null) {
                ++n;
                node = node.parent;
            }
            return n;
        }

        public int getMaxDepth() {
            int n = this.children.size();
            if (n == 0) {
                return 0;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (Node node : this.children) {
                arrayList.add(new Integer(node.getMaxDepth()));
            }
            return (Integer)Collections.max(arrayList) + 1;
        }

        public Iterator iterator(IterationOrder iterationOrder) {
            return iterationOrder.iterator(this);
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public boolean valEquals(Node node, Node node2) {
            if (node == null || node2 == null) {
                return false;
            }
            Object object = node.data;
            return object != null && object.equals(node2.data);
        }

        public String toString() {
            if (this.data == null) {
                return "Node[no data]";
            }
            return this.data.toString();
        }
    }
}

