/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Args;
import fc.util.Watch;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Random;

public final class UUIDUtil {
    static MessageDigest digester = null;
    static final char[] lookup;
    static final int[] reverselookup;
    static char[] URL_safe_chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String newSessionID() {
        long l = System.currentTimeMillis();
        Random random = new Random();
        int n = random.nextInt();
        String string = String.valueOf(l) + n;
        byte[] byArray = null;
        Object object = UUIDUtil.class;
        synchronized (UUIDUtil.class) {
            byArray = digester.digest(string.getBytes());
            // ** MonitorExit[var6_5] (shouldn't be in output)
            object = null;
            object = UUIDUtil.encode(byArray);
            return new String((char[])object);
        }
    }

    private static final char[] encode(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = byArray[n2] >> 4 & 0xF;
            int n5 = byArray[n2] & 0xF;
            cArray[n3] = lookup[n4];
            cArray[n3 + 1] = lookup[n5];
            ++n2;
            n3 += 2;
        }
        return cArray;
    }

    private static final byte[] decode(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n / 2 + n % 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = cArray[n2] & 0xFF;
            int n5 = cArray[n2 + 1] & 0xFF;
            if (n4 > 127 || n5 > 127) {
                throw new IllegalArgumentException("malformed bufing, encoded with characters I don't understand [" + n4 + "] and [" + n5 + "]");
            }
            int n6 = reverselookup[n4] << 4 | reverselookup[n5];
            byArray[n3] = (byte)n6;
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    public static String newID(int n) {
        Random random = new Random();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = URL_safe_chars[random.nextInt(URL_safe_chars.length)];
        }
        return new String(cArray);
    }

    public static String newID() {
        return UUIDUtil.newID(8);
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        Args args = new Args(stringArray);
        int n2 = args.getInt("loop", 100000);
        args.setUsage("java fc.util.UUIDUtil [-loop <int, default 100,000>]");
        if (args.flagExists("help")) {
            args.showError();
            return;
        }
        System.out.println("Session ID: " + UUIDUtil.newSessionID());
        System.out.println("Generating " + n2 + " test session ids...");
        Watch watch = new Watch();
        HashMap hashMap = null;
        int n3 = -1;
        watch.start();
        for (n = 0; n < n2; ++n) {
            string = UUIDUtil.newSessionID();
        }
        System.out.println("Time for " + n2 + ": " + watch.time() + " ms");
        System.out.println("Now testing for collisions...");
        watch.restart();
        hashMap = new HashMap();
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            string = UUIDUtil.newSessionID();
            if (hashMap.containsKey(string)) {
                System.out.println("collision found with key: " + string);
                ++n3;
            }
            if (n > 0 && n % 20000 == 0) {
                watch.stop();
                System.out.println("generated: " + n + " (+ " + watch.time() + " ms)");
                watch.restart();
            }
            hashMap.put(string, null);
        }
        if (n3 == 0) {
            System.out.println("No collisions found...");
        } else {
            System.out.println(n3 + " collisions found...");
        }
        System.out.println("------------------------------");
        watch.restart();
        System.out.println("newID (8): " + UUIDUtil.newID(8));
        System.out.println("Generating " + n2 + " test session ids...");
        for (n = 0; n < n2; ++n) {
            string = UUIDUtil.newID(8);
        }
        System.out.println("Time for " + n2 + ": " + watch.time() + " ms");
        System.out.println("Now testing for collisions...");
        watch.restart();
        hashMap = new HashMap();
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            string = UUIDUtil.newID(8);
            if (hashMap.containsKey(string)) {
                System.out.println("collision found with key: " + string);
                ++n3;
            }
            if (n > 0 && n % 20000 == 0) {
                watch.stop();
                System.out.println("generated: " + n + " (+ " + watch.time() + " ms)");
                watch.restart();
            }
            hashMap.put(string, null);
        }
        if (n3 == 0) {
            System.out.println("No collisions found...");
        } else {
            System.out.println(n3 + " collisions found...");
        }
    }

    static {
        try {
            digester = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        lookup = "wInteEMubY2169x0".toCharArray();
        reverselookup = new int[128];
        int n = 0;
        while (n < 16) {
            int n2 = lookup[n] & 0xFF;
            UUIDUtil.reverselookup[n2] = n++;
        }
        URL_safe_chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789_-.~".toCharArray();
    }
}

