/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

public class Watch {
    String myname;
    volatile boolean running = false;
    long startTime = -1L;
    long stopTime;
    long cumulativeTime;

    public Watch(String string) {
        this.myname = string;
    }

    public Watch() {
        this("DefaultWatch/" + Thread.currentThread().getName());
    }

    public Watch start() {
        this.startTime = System.currentTimeMillis();
        this.running = true;
        return this;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.cumulativeTime += this.stopTime - this.startTime;
        this.running = false;
    }

    public long time() {
        if (this.startTime == -1L) {
            throw new RuntimeException("You need to start the watch at least once before calling this method");
        }
        if (this.running) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public long getTime() {
        return this.time();
    }

    public long timeInSeconds() {
        long l = this.getTime();
        if (l < 500L) {
            return 0L;
        }
        if (l <= 1000L) {
            return 1L;
        }
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        return l2 + (long)(l3 < 500L ? 0 : 1);
    }

    public long getTimeInSeconds() {
        return this.timeInSeconds();
    }

    public long seconds() {
        return this.timeInSeconds();
    }

    public long elapsed() {
        return this.timeInSeconds();
    }

    public long timeSeconds() {
        return this.timeInSeconds();
    }

    public double timeMillis() {
        return this.getTimeInMillis();
    }

    public double getTimeInMillis() {
        return (double)this.getTime() * 1.0;
    }

    public long cumulativeTime() {
        if (!this.running) {
            return this.cumulativeTime;
        }
        return this.cumulativeTime + (System.currentTimeMillis() - this.startTime);
    }

    public void reset() {
        this.stopTime = 0L;
        this.startTime = 0L;
    }

    public void restart() {
        this.reset();
        this.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    protected long getStart() {
        return this.startTime;
    }

    protected long getStop() {
        return this.stopTime;
    }

    public String toString() {
        String string = this.myname;
        string = string + ": Cum.Time=[" + this.cumulativeTime() + " ms]" + "; Start=[" + this.startTime + "]";
        string = !this.running ? string + "; Stop=[" + this.stopTime + "]" : string + "; Elapsed=[" + this.time() + " ms]";
        return string;
    }

    public static void main(String[] stringArray) {
        Watch watch = new Watch("Watch 1");
        watch.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Watch watch = new Watch();
                    watch.start();
                    Thread.currentThread();
                    Thread.sleep(20L);
                    watch.stop();
                    System.out.println("t2.toString():" + watch);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
        System.out.println("Watch 1, total time taken:" + watch.time());
        System.out.println("Watch 1, time=" + watch.time());
        System.out.println("Watch 1, before-being-stopped, toString():" + watch);
        watch.stop();
        System.out.println("Watch 1, is running ? " + watch.isRunning());
        System.out.println("Watch 1, after-being-stopped, toString():" + watch);
        System.out.println("Watch 1, elapsed time:" + watch.time());
        System.out.println("Watch 1, cumulative time taken:" + watch.cumulativeTime());
        System.out.println("Watch 1, elapsed time:" + watch.time());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Watch watch = new Watch();
                    watch.start();
                    Thread.currentThread();
                    Thread.sleep(250L);
                    watch.stop();
                    System.out.println("After sleeping 250ms: time in seconds:  " + watch.getTimeInSeconds());
                    watch.start();
                    Thread.currentThread();
                    Thread.sleep(500L);
                    System.out.println("After sleeping 750ms: time in seconds:  " + watch.getTimeInSeconds());
                    Thread.currentThread();
                    Thread.sleep(500L);
                    System.out.println("After sleeping 1250ms: time in seconds: " + watch.getTimeInSeconds());
                    Thread.currentThread();
                    Thread.sleep(500L);
                    System.out.println("After sleeping 1750ms: time in seconds: " + watch.getTimeInSeconds());
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    System.out.println("After sleeping 2750ms: time in seconds: " + watch.getTimeInSeconds());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }
}

