/*
 * Decompiled with CFR 0.152.
 */
package fc.util.cache;

import fc.io.Log;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.cache.Cache;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MemoryCache
implements Cache {
    public static final long ONE_SEC = 1000L;
    public static final long ONE_SECOND = 1000L;
    public static final long FIVE_SEC = 5000L;
    public static final long FIVE_SECOND = 5000L;
    public static final long TEN_SEC = 10000L;
    public static final long TEN_SECOND = 10000L;
    public static final long THIRTY_SEC = 30000L;
    public static final long THIRTY_SECOND = 30000L;
    public static final long ONE_MIN = 60000L;
    public static final long TWO_MIN = 120000L;
    public static final long FIVE_MIN = 300000L;
    public static final long TEN_MIN = 600000L;
    public static final long THIRTY_MIN = 1800000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long TWO_HOUR = 0x6DDD00L;
    public static final long FOUR_HOUR = 14400000L;
    public static final long EIGHT_HOUR = 28800000L;
    final String myName;
    final Map cache;
    volatile boolean closed = false;
    volatile long defaultTTL;
    volatile long reapInterval;
    CacheReaperThread reaperThread;
    final Log log;

    public MemoryCache(Log log, String string, long l) {
        if (log == null) {
            log = Log.getDefault();
        }
        this.log = log;
        this.myName = string;
        this.defaultTTL = l;
        this.reapInterval = 120000L;
        this.cache = Collections.synchronizedMap(new HashMap());
        this.reaperThread = new CacheReaperThread();
    }

    public MemoryCache() {
        this(null, "MemoryCache/created@" + DateFormat.getDateTimeInstance(3, 3).format(new Date()), 1800L);
    }

    public void setReapInterval(long l) {
        this.reapInterval = l;
    }

    public void setReapThreadPriority(int n) {
        this.reaperThread.setPriority(n);
    }

    @Override
    public boolean containsKey(Object object) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        CacheItem cacheItem = (CacheItem)this.cache.get(object);
        if (cacheItem == null) {
            return false;
        }
        return !cacheItem.hasExpired();
    }

    @Override
    public Object get(Object object) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        CacheItem cacheItem = (CacheItem)this.cache.get(object);
        if (cacheItem == null) {
            return null;
        }
        if (cacheItem.hasExpired()) {
            return null;
        }
        return cacheItem.getValue();
    }

    @Override
    public Map getAll() {
        return this.cache;
    }

    @Override
    public long getTimeLeft(Object object) {
        CacheItem cacheItem = (CacheItem)this.cache.get(object);
        if (cacheItem == null) {
            return 0L;
        }
        if (cacheItem.expire == -1L) {
            return -1L;
        }
        long l = cacheItem.calcTimeLeft();
        if (l <= 0L) {
            return 0L;
        }
        return l;
    }

    @Override
    public Object put(Object object, Object object2, long l) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        Argcheck.istrue(l >= 0L || l == -1L, "Illegal value [" + l + "] for the expiry argument, need the value to be >=0 or -1");
        CacheItem cacheItem = new CacheItem(object, object2, l);
        CacheItem cacheItem2 = this.cache.put(object, cacheItem);
        if (cacheItem2 != null) {
            return cacheItem2.getValue();
        }
        return null;
    }

    @Override
    public Object put(Object object, Object object2) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        return this.put(object, object2, this.getDefaultTTL());
    }

    public long expireTimeLeft(Object object) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        Object v = this.cache.get(object);
        if (v == null) {
            return 0L;
        }
        return ((CacheItem)v).expireTimeLeft();
    }

    @Override
    public void expire(Object object) {
        CacheItem cacheItem;
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        Object v = this.cache.get(object);
        if (v != null && !(cacheItem = (CacheItem)v).hasExpired()) {
            cacheItem.expireNow();
        }
    }

    @Override
    public void extend(Object object, long l) {
        CacheItem cacheItem;
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        Argcheck.istrue(l >= 0L || l == -1L, "Illegal value [" + l + "] for the renewTime argument, need the value to be >=0 or -1");
        Object v = this.cache.get(object);
        if (v != null && (cacheItem = (CacheItem)v) != null && !cacheItem.hasExpired()) {
            cacheItem.renew(l);
        }
    }

    @Override
    public void close() {
        this.reaperThread.stopThread();
        this.closed = true;
        this.log.info("*** cache:[", this.myName, "] closed. ***");
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setDefaultTTL(long l) {
        this.defaultTTL = l;
    }

    @Override
    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public String toString() {
        int n = this.cache.size();
        String string = this.myName + "; contains ";
        string = string + (n == Integer.MAX_VALUE ? Integer.toString(n) : Integer.toString(n) + " (or greater)");
        string = string + " items; ";
        string = string + (this.isClosed() ? "cache is closed. " : "cache is open.");
        return string;
    }

    public static void main(String[] stringArray) {
        new Test(new Args(stringArray));
    }

    private static class Test {
        Test(Args args) {
            try {
                int n;
                MemoryCache memoryCache = new MemoryCache();
                memoryCache.setReapInterval(5000L);
                memoryCache.log.setLevel(args.get("log", "debug"));
                memoryCache.put("key1", "val1");
                memoryCache.put(null, "val2");
                memoryCache.put("key3", null);
                memoryCache.put(null, null);
                System.out.println("key1 = " + memoryCache.get("key1"));
                System.out.println("key2 = " + memoryCache.get("key2"));
                System.out.println("key3 = " + memoryCache.get("key3"));
                int n2 = 10;
                System.out.println("adding: " + n2 + " key,val pairs");
                for (n = 0; n < n2; ++n) {
                    memoryCache.put("key" + n, "val" + n);
                }
                System.out.println("finished adding. cache now contains the following");
                for (n = 0; n < n2; ++n) {
                    System.out.println("key" + n + "=" + memoryCache.get("key" + n));
                }
                System.out.println("Now expiring every other item");
                for (n = 0; n < n2; ++n) {
                    if (n % 2 == 0) continue;
                    memoryCache.expire("key" + n);
                }
                System.out.println("Expire times for cache entries:");
                for (n = 0; n < n2; ++n) {
                    System.out.println("key" + n + "=" + memoryCache.getTimeLeft("key" + n));
                }
                System.out.println("Sleeping for 30 seconds...give reaper time to do it's thing.");
                Thread.currentThread();
                Thread.sleep(30000L);
                System.out.println("Expiring finished, cache now contains the following (expired keys should return null)");
                for (n = 0; n < n2; ++n) {
                    System.out.println("key" + n + "=" + memoryCache.get("key" + n));
                }
                System.out.println("Expire time for 'key1' is: " + memoryCache.getTimeLeft("key1"));
                System.out.println("Expire time for 'key2' is: " + memoryCache.getTimeLeft("key2"));
                System.out.println("closing cache");
                memoryCache.close();
                System.out.println("mycache.toString() = " + memoryCache);
                System.out.println("the following should throw an Exception");
                memoryCache.put("foo", "bar");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    final class CacheReaperThread
    extends Thread {
        volatile boolean stop = false;

        public CacheReaperThread() {
            this.setName("CacheReaperThread->[" + MemoryCache.this.myName + "]");
            this.setPriority(9);
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MemoryCache.this.log.bug("CacheReaperThread for cache:[", MemoryCache.this.myName, "] started...");
            while (!this.stop) {
                try {
                    CacheReaperThread cacheReaperThread = this;
                    synchronized (cacheReaperThread) {
                        this.wait(MemoryCache.this.reapInterval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                MemoryCache.this.log.bug("CacheReaperThread for cache:[", MemoryCache.this.myName, "] now running reapCache()");
                this.reapCache();
            }
        }

        public void stopThread() {
            this.stop = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void reapCache() {
            MemoryCache.this.log.bug("waiting for memorycache object lock");
            Map map = MemoryCache.this.cache;
            synchronized (map) {
                MemoryCache.this.log.bug("acquired lock for cache, now running reap loop");
                Iterator iterator = MemoryCache.this.cache.entrySet().iterator();
                while (iterator.hasNext()) {
                    CacheItem cacheItem = (CacheItem)iterator.next().getValue();
                    if (!cacheItem.hasExpired()) continue;
                    MemoryCache.this.log.bug("Reaping: ", cacheItem);
                    iterator.remove();
                }
            }
        }
    }

    private class CacheItem {
        final Object key;
        final Object val;
        final long startTime;
        long expire;
        long lastAccessTime;

        CacheItem(Object object, Object object2, long l) {
            this.key = object;
            this.val = object2;
            this.expire = l;
            this.startTime = System.currentTimeMillis();
            this.lastAccessTime = 0L;
        }

        boolean hasExpired() {
            if (this.expire == -1L) {
                return false;
            }
            return this.calcTimeLeft() <= 0L;
        }

        void renew(long l) {
            if (this.expire == -1L) {
                this.expire = 0L;
            }
            this.expire += l;
        }

        void expireNow() {
            this.expire = 0L;
        }

        long expireTimeLeft() {
            if (this.expire == -1L) {
                return 0L;
            }
            return this.calcTimeLeft();
        }

        long calcTimeLeft() {
            return this.expire + this.startTime - System.currentTimeMillis();
        }

        Object getValue() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.val;
        }

        public String toString() {
            return "(MemoryCache.CacheItem: Expired=" + this.hasExpired() + ";<" + this.key + ">=<" + this.val + ">)";
        }
    }
}

