/*
 * Decompiled with CFR 0.152.
 */
package fc.util.pagetemplate;

import fc.io.IOUtil;
import fc.io.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Map;

public abstract class TemplatePage {
    private static final boolean internal_dbg = false;
    public static String PACKAGE_NAME = "molly.pagetemplate";
    public static String DEFAULT_ENCODING = "UTF-8";
    protected volatile boolean dbg = false;
    public Log log = Log.getDefault();
    public Writer out;
    public File templateFile;
    public Connection con;
    public Map context;

    public void setSourcePath(File file) {
        this.templateFile = file;
    }

    public String getSourcePath() {
        return this.templateFile.getAbsolutePath();
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    public void setContext(Map map) {
        this.context = map;
    }

    public void render(Writer writer) throws Exception {
        this.render(IOUtil.toPrintWriter(IOUtil.bufferWriter(writer)));
    }

    public void render(File file) throws Exception {
        this.render(new PrintWriter(file, DEFAULT_ENCODING));
    }

    public void render(OutputStream outputStream) throws Exception {
        this.render(new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, DEFAULT_ENCODING))));
    }

    public abstract void render(PrintWriter var1) throws Exception;

    public final void dbg(boolean bl) {
        this.dbg = bl;
    }

    public final void bug(Writer writer, Object object) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(object != null ? object.toString() : "null");
    }

    public final void bug(Writer writer, Object object, Object ... objectArray) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(object != null ? object.toString() : "null");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            writer.append(objectArray[i] != null ? objectArray[i].toString() : "null");
        }
    }
}

