/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class ChoiceGroup
extends Field {
    private Map options = new LinkedHashMap();
    private List optionsList = new ArrayList();
    private Map origSelectedMap = new HashMap();
    private boolean reverseRender = false;
    private Map reverseOptions;

    public ChoiceGroup(String string) {
        super(string);
    }

    public ChoiceGroup(String string, List list) {
        super(string);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Choice choice = (Choice)list.get(i);
                this.add(choice);
                choice.parent = this;
            }
        }
        catch (ClassCastException classCastException) {
            log.warn("You can only add choices of type: ChoiceGroup.Choice. This is different than just the Choice type.");
            throw classCastException;
        }
    }

    @Override
    public abstract Field.Type getType();

    public void add(Choice choice) {
        String string = choice.getValue();
        this.options.put(string, choice);
        this.optionsList.add(choice);
        if (choice.isOrigSelected()) {
            this.origSelectedMap.put(string, choice);
        }
        this.reverseOptions = null;
        choice.parent = this;
    }

    public void addAll(ChoiceGroup choiceGroup) {
        Argcheck.notnull(choiceGroup, "choicegroup parameter was null");
        Argcheck.istrue(choiceGroup != this, "source and target choicegroups are the same");
        for (Choice choice : choiceGroup.options.values()) {
            choice.copyTo(this);
        }
    }

    public Collection getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return Form.empty_list;
        }
        return data.selectedMap.values();
    }

    public void setValue(FormData formData, Collection collection) {
        Argcheck.notnull(formData, "specified fd param was null");
        Argcheck.notnull(collection, "specified values param was null");
        Data data = new Data();
        formData.putData(this.name, data);
        for (Choice choice : collection) {
            if (!choice.isOrigSelected()) continue;
            data.selectedMap.put(choice.getValue(), choice);
        }
    }

    public void setValue(Collection collection) {
        Argcheck.notnull(collection, "specified values param was null");
        for (Choice choice : collection) {
            this.add(choice);
        }
    }

    public Choice getChoice(int n) {
        return (Choice)this.optionsList.get(n);
    }

    @Override
    public boolean isFilled(FormData formData) {
        if (formData == null) {
            return false;
        }
        Data data = (Data)formData.getData(this.name);
        return data != null && data.selectedMap.size() != 0;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String[] stringArray = httpServletRequest.getParameterValues(this.name);
        if (stringArray == null) {
            return;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        for (int i = 0; i < stringArray.length; ++i) {
            Choice choice = (Choice)this.options.get(stringArray[i]);
            if (choice == null) {
                StringBuffer stringBuffer = new StringBuffer(512);
                stringBuffer.append(".setSubmittedValue(): could not match/retrieve a submitted choice from the optionMap").append("fieldname=").append(this.name).append("; submited value='").append(stringArray[i]).append("'; choices=").append(this.options);
                this.hacklert(httpServletRequest, stringBuffer.toString());
                continue;
            }
            data.selectedMap.put(choice.getValue(), choice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseRender(boolean bl) {
        ChoiceGroup choiceGroup = this;
        synchronized (choiceGroup) {
            this.reverseRender = bl;
            if (this.reverseRender && this.reverseOptions == null) {
                int n;
                this.reverseOptions = new LinkedHashMap();
                ArrayList arrayList = new ArrayList();
                Iterator iterator = this.options.entrySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                for (int i = n = arrayList.size() - 1; i >= 0; --i) {
                    Map.Entry entry = (Map.Entry)arrayList.get(i);
                    this.reverseOptions.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        this.renderImpl(formData, writer, null, "&nbsp;");
    }

    public void renderImpl(FormData formData, Writer writer, String string, String string2) throws IOException {
        Data data = null;
        if (formData != null) {
            data = (Data)formData.getData(this.name);
        }
        Iterator iterator = null;
        iterator = this.reverseRender ? this.reverseOptions.values().iterator() : this.options.values().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Choice choice = (Choice)iterator.next();
            String string3 = choice.getValue();
            boolean bl2 = false;
            bl2 = formData != null ? (data != null ? data.selectedMap.containsKey(string3) : false) : this.origSelectedMap.containsKey(string3);
            boolean bl3 = bl = !this.isEnabled(formData);
            if (string != null) {
                writer.write(string);
            }
            choice.render(writer, bl2, bl);
            if (string2 == null) continue;
            writer.write(string2);
        }
    }

    public void reset() {
        this.options.clear();
        this.optionsList.clear();
        this.origSelectedMap.clear();
        this.reverseRender = false;
        if (this.reverseOptions != null) {
            this.reverseOptions.clear();
        }
    }

    public Map getAllElements() {
        return this.options;
    }

    public boolean isSelected(FormData formData, Choice choice, boolean bl) {
        if (formData == null) {
            return bl;
        }
        Argcheck.notnull(choice, "choice param was null");
        String string = choice.getValue();
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return bl;
        }
        boolean bl2 = data.selectedMap.containsKey(string);
        return bl2;
    }

    public void writeLabel(boolean bl) {
        for (Choice choice : this.options.values()) {
            choice.writeLabel(bl);
        }
    }

    @Override
    public String toString() {
        String string = IOUtil.LINE_SEP;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("; Orig. values: ");
        stringBuffer.append(string);
        Iterator iterator = null;
        iterator = this.reverseRender ? this.reverseOptions.values().iterator() : this.options.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t");
            stringBuffer.append(iterator.next());
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static class Choice {
        private ChoiceGroup parent;
        private String value;
        private String label;
        private String labelsep = " ";
        private boolean orig_selected;
        private boolean writeLabel = true;
        private boolean writeLabelAfter = true;
        private boolean writeLabelBefore = false;

        public Choice(String string, String string2, boolean bl) {
            this.label = string;
            this.value = string2;
            this.orig_selected = bl;
        }

        public Choice(String string, String string2) {
            this(string, string2, false);
        }

        public Choice(String string, boolean bl) {
            this(string, null, bl);
        }

        private void copyTo(ChoiceGroup choiceGroup) {
            Choice choice = new Choice(this.value, this.label, this.orig_selected);
            choice.writeLabel = this.writeLabel;
            choice.writeLabelAfter = this.writeLabelAfter;
            choice.writeLabelBefore = this.writeLabelBefore;
            choiceGroup.add(choice);
        }

        public void labelBeforeField() {
            this.writeLabelAfter = false;
            this.writeLabelBefore = true;
        }

        public void writeLabel(boolean bl) {
            this.writeLabel = bl;
        }

        public void render(FormData formData, Writer writer, boolean bl) throws IOException {
            Data data = null;
            if (formData != null) {
                data = (Data)formData.getData(this.parent.name);
            }
            boolean bl2 = false;
            bl2 = formData != null ? (data != null ? data.selectedMap.containsKey(this.getValue()) : false) : this.isOrigSelected();
            this.render(writer, bl2, bl);
        }

        public void render(Writer writer, boolean bl, boolean bl2) throws IOException {
            if (this.writeLabel && this.writeLabelBefore) {
                writer.write(this.label);
                writer.write(this.labelsep);
            }
            writer.write("<input type='");
            writer.write(this.parent.getType().toString());
            writer.write("' name='");
            writer.write(this.parent.name);
            writer.write("'");
            if (this.value != null) {
                writer.write(" value='");
                writer.write(this.value);
                writer.write("'");
            }
            if (bl) {
                writer.write(" checked");
            }
            if (this.parent.renderStyleTag) {
                writer.write(" style='");
                writer.write(this.parent.styleTag);
                writer.write("'");
            }
            int n = this.parent.arbitraryString.size();
            for (int i = 0; i < n; ++i) {
                writer.write(" ");
                writer.write(this.parent.arbitraryString.get(i).toString());
            }
            writer.write(">");
            if (this.writeLabel && this.writeLabelAfter) {
                writer.write(this.labelsep);
                writer.write(this.label);
            }
            writer.write("</input>");
        }

        public String getValue() {
            if (this.value != null) {
                return this.value;
            }
            return this.label;
        }

        public int getIntValue() {
            return Integer.parseInt(this.getValue());
        }

        public short getShortValue(FormData formData) {
            return Short.parseShort(this.getValue());
        }

        public boolean getBooleanValue(FormData formData) {
            return Boolean.valueOf(this.getValue());
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabelSeperator(String string) {
            this.labelsep = string;
        }

        public boolean isOrigSelected() {
            return this.orig_selected;
        }

        public String toString() {
            return "ChoiceGroup.Choice: [value=" + this.value + "; label=" + this.label + "]";
        }
    }

    static class Data {
        Map selectedMap = new HashMap();

        Data() {
        }
    }
}

