/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Select
extends Field {
    LinkedHashMap options = new LinkedHashMap();
    Map origSelectedMap = new HashMap();
    int size = 0;
    boolean multiple;

    public Select(String string) {
        super(string);
    }

    public Select(String string, List list) {
        super(string);
        Argcheck.notnull(list, "values param was null");
        this.initOptions(list);
    }

    void initOptions(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Option option = (Option)list.get(i);
            String string = option.getValue();
            this.options.put(string, option);
            if (!option.isOrigSelected()) continue;
            this.origSelectedMap.put(string, option);
        }
    }

    public Select useQuery(Connection connection, String string, Option option) throws SQLException {
        this.reset();
        if (option != null) {
            this.add(option);
        }
        List list = Select.makeOptionsFromQuery(connection, string);
        this.initOptions(list);
        return this;
    }

    public Select useQuery(Connection connection, String string) throws SQLException {
        this.useQuery(connection, string, null);
        return this;
    }

    public static List makeOptionsFromQuery(Connection connection, String string) throws SQLException {
        return Select.makeOptionsFromQuery(connection, string, null);
    }

    public static List makeOptionsFromQuery(Connection connection, String string, Option option) throws SQLException {
        Statement statement;
        ResultSet resultSet;
        ResultSetMetaData resultSetMetaData;
        int n;
        ArrayList<Option> arrayList = new ArrayList<Option>();
        if (option != null) {
            arrayList.add(option);
        }
        if ((n = (resultSetMetaData = (resultSet = (statement = connection.createStatement()).executeQuery(string)).getMetaData()).getColumnCount()) == 0) {
            log.warn("Query [", string, "] returned no columns");
        }
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            String string3 = n == 1 ? string2 : resultSet.getString(2);
            Option option2 = new Option(string2, string3);
            arrayList.add(option2);
        }
        statement.close();
        return arrayList;
    }

    @Override
    public Field.Type getType() {
        return Field.Type.SELECT;
    }

    public void setValue(List list) {
        Argcheck.notnull(list, "specified values param was null");
        this.options.clear();
        this.origSelectedMap.clear();
        this.initOptions(list);
    }

    public List getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return Form.empty_list;
        }
        return data.selectedList;
    }

    public String getStringValue(FormData formData) {
        String string = null;
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        List list = data.selectedList;
        if (list.size() == 0) {
            return string;
        }
        Option option = (Option)list.get(0);
        return option.getValue();
    }

    public int getIntValue(FormData formData) {
        return Integer.parseInt(this.getStringValue(formData));
    }

    public boolean getBooleanValue(FormData formData) {
        return Boolean.valueOf(this.getStringValue(formData));
    }

    @Override
    public boolean isFilled(FormData formData) {
        if (formData == null) {
            return false;
        }
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return false;
        }
        List list = data.selectedList;
        return list.size() != 0;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String[] stringArray = httpServletRequest.getParameterValues(this.name);
        if (stringArray == null) {
            return;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        if (this.multiple && stringArray.length > 1) {
            this.hacklert(httpServletRequest, "recieved multiple values for a single value select");
        }
        if (this.multiple) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addSelectedOpt(httpServletRequest, data, stringArray[i]);
            }
        } else {
            this.addSelectedOpt(httpServletRequest, data, stringArray[0]);
        }
    }

    private void addSelectedOpt(HttpServletRequest httpServletRequest, Data data, String string) throws SubmitHackedException {
        Option option = (Option)this.options.get(string);
        if (option == null) {
            this.hacklert(httpServletRequest, "could not match/retrieve a submitted option from the options.; Submited value=[" + string + "]; options=" + this.options);
        } else {
            data.selectedMap.put(option.getValue(), option);
            data.selectedList.add(option);
        }
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        Data data = null;
        if (formData != null) {
            data = (Data)formData.getData(this.name);
        }
        writer.write("<select");
        writer.write(" name='");
        writer.write(this.name);
        writer.write("'");
        if (this.size > 0) {
            writer.write(" size='");
            writer.write(String.valueOf(this.size));
            writer.write("'");
        }
        if (!this.enabled || !this.isEnabled(formData)) {
            writer.write(" disabled");
        }
        if (this.multiple) {
            writer.write(" multiple");
        }
        if (this.renderStyleTag) {
            writer.write(" style='");
            writer.write(this.styleTag);
            writer.write("'");
        }
        int n = this.arbitraryString.size();
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
            writer.write(this.arbitraryString.get(i).toString());
        }
        writer.write(">\n");
        for (Option option : this.options.values()) {
            String string = option.getValue();
            boolean bl = false;
            if (formData != null) {
                if (data != null) {
                    bl = data.selectedMap.containsKey(string);
                }
            } else {
                bl = this.origSelectedMap.containsKey(string);
            }
            writer.write(option.render(bl));
            writer.write("\n");
        }
        writer.write("</select>");
    }

    public void add(Option option) {
        Argcheck.notnull(option, "opt param was null");
        String string = option.getValue();
        this.options.put(string, option);
        if (option.isOrigSelected()) {
            this.origSelectedMap.put(string, option);
        }
    }

    public void add(String string) {
        Argcheck.notnull(string, "item param was null");
        Option option = new Option(string);
        this.add(option);
    }

    public void reset() {
        this.options.clear();
        this.origSelectedMap.clear();
    }

    public Select setSize(int n) {
        this.size = n;
        return this;
    }

    public Select allowMultiple(boolean bl) {
        this.multiple = bl;
        return this;
    }

    public static final class Option {
        private String value;
        private String text;
        private boolean orig_selected;

        public Option(String string, String string2, boolean bl) {
            this.text = string;
            this.value = string2;
            this.orig_selected = bl;
        }

        public Option(String string, String string2) {
            this(string, string2, false);
        }

        public Option(String string, boolean bl) {
            this(string, null, bl);
        }

        public Option(String string) {
            this(string, null, false);
        }

        boolean isOrigSelected() {
            return this.orig_selected;
        }

        public String getValue() {
            if (this.value != null) {
                return this.value;
            }
            return this.text;
        }

        public String render(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("<option");
            if (this.value != null) {
                stringBuffer.append(" value='");
                stringBuffer.append(this.value);
                stringBuffer.append("'");
            }
            if (bl) {
                stringBuffer.append(" SELECTED");
            }
            stringBuffer.append(">");
            stringBuffer.append(this.text);
            stringBuffer.append("</option>");
            return stringBuffer.toString();
        }

        public String toString() {
            return this.render(false);
        }
    }

    static final class Data {
        private Map selectedMap = new HashMap();
        private List selectedList = new ArrayList();

        Data() {
        }
    }
}

