/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.IOUtil;
import fc.io.Log;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.ClassUtil;
import fc.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PageClassLoader
extends ClassLoader {
    private static final boolean dbg = false;
    Log log;
    Map class_file_paths = new HashMap();

    public PageClassLoader(Log log) {
        this.log = log;
    }

    public PageClassLoader() {
        this.log = Log.getDefault();
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.startsWith("molly.pages")) {
            Class clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            int n = "molly.pages".length() + 1;
            if (!(string = string.substring(n, string.length())).endsWith(".class")) {
                String string2 = string.substring(0, string.indexOf("$"));
                String string3 = (String)this.class_file_paths.get(string2);
                if (string3 == null) {
                    throw new ClassNotFoundException("Internal error: cannot load anonymous/inner classe: " + string);
                }
                string = string3 + string + ".class";
            } else {
                String string4 = StringUtil.dirName(string);
                String string5 = StringUtil.fileName(string);
                string5 = string5.substring(0, string5.indexOf(".class"));
                this.class_file_paths.put(string5, string4);
            }
            clazz = this.readClassFromDisk(new File(string));
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return Thread.currentThread().getContextClassLoader().loadClass(string);
    }

    Class readClassFromDisk(File file) throws ClassNotFoundException {
        Argcheck.istrue(file.exists(), "The specified file does not exist: " + file.getAbsolutePath());
        byte[] byArray = null;
        try {
            byArray = IOUtil.fileToByteArray(file);
            if (byArray == null) {
                throw new ClassNotFoundException(file.getPath());
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(file.getPath());
        }
        if (this.getPackage("molly.pages") == null) {
            this.definePackage("molly.pages", null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length);
        return clazz;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java " + ClassUtil.getClassName() + " -file full-path-to-class-file");
        String string = "molly.pages." + args.getRequired("file");
        PageClassLoader pageClassLoader = new PageClassLoader();
        pageClassLoader.log.setLevel("debug");
        System.out.println("Loading java.lang.object: ");
        Class<?> clazz = pageClassLoader.loadClass("java.lang.Object");
        System.out.println(ClassUtil.getClassLoaderInfo(clazz));
        System.out.println("Loading " + string);
        clazz = pageClassLoader.loadClass(string);
        System.out.println(ClassUtil.getClassLoaderInfo(clazz));
        System.out.println("Package for this class: " + clazz.getPackage());
    }
}

