/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.util.Args;
import fc.util.ClassUtil;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class PageCompiler {
    private static final boolean dbg = false;
    String error;
    File javafile;
    String classpath;
    String encoding;

    public PageCompiler(File file) {
        this.javafile = file;
    }

    public PageCompiler(File file, String string, String string2) {
        this.javafile = file;
        this.classpath = string;
        this.encoding = string2;
    }

    public String getError() {
        return this.error;
    }

    public boolean compile() throws IOException {
        if (this.javafile.length() == 0L) {
            this.error = "Java source file [" + this.javafile.getCanonicalPath() + "] size was 0 bytes. This file cannot be compiled";
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("javac");
        arrayList.add("-nowarn");
        if (this.encoding != null) {
            arrayList.add("-encoding");
            arrayList.add(this.encoding);
        }
        if (this.classpath != null) {
            arrayList.add("-classpath");
            arrayList.add(this.classpath);
        }
        arrayList.add(this.javafile.getCanonicalPath());
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        Process process = processBuilder.start();
        int n = 0;
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getInputStream());
        int n2 = ((InputStream)bufferedInputStream).read();
        while (n2 != -1) {
            charArrayWriter.write((char)n2);
            n2 = ((InputStream)bufferedInputStream).read();
        }
        n2 = ((InputStream)bufferedInputStream2).read();
        if (n2 != -1) {
            charArrayWriter.append("-------------------------------------------");
        }
        while (n2 != -1) {
            charArrayWriter.write((char)n2);
            n2 = ((InputStream)bufferedInputStream2).read();
        }
        this.error = charArrayWriter.toString();
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        return n == 0;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java " + ClassUtil.getClassName() + " -file path-to-file-to-compile [-classpath <class-path> -encoding encoding]");
        PageCompiler pageCompiler = new PageCompiler(new File(args.getRequired("file")), args.get("classpath", System.getProperty("java.class.path")), args.get("encoding", null));
        if (!pageCompiler.compile()) {
            System.out.println(pageCompiler.getError());
        }
    }
}

