/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.IOUtil;
import fc.io.Log;
import fc.io.SystemLog;
import fc.io.TablePrinter;
import fc.io.fileselectors.SuffixSelector;
import fc.util.Args;
import fc.util.Watch;
import fc.web.page.PageCompiler;
import fc.web.page.PageParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PageParserTest {
    static List results = new ArrayList();

    public static void main(String[] stringArray) throws Exception {
        Object[] objectArray;
        int n;
        Object object;
        Args args = new Args(stringArray);
        SystemLog systemLog = Log.getDefault();
        args.setUsage("java " + args.getMainClassName() + "\n---- Specify ---" + "\n   -test   <if specified, run all unit tests with the latest parser>" + "\n   -tmpdir <location to a tmp dir used for generated files" + "\n----- or ----" + "\n   -generateExpected if specified, expected/canonical parser output " + "\n                     is generated. Use with caution. The servlet API" + "\n                     along with all the molly classes must be on the" + "\n                     system classpath for this option to work fully.");
        boolean bl = args.flagExists("test");
        boolean bl2 = args.flagExists("generateExpected");
        File file = null;
        if (!bl && !bl2) {
            args.showError();
        }
        if (bl && !(file = new File(args.getRequired("tmpdir"))).exists()) {
            systemLog.error("The specified temp directory: " + file.getAbsolutePath() + " does not exist");
            return;
        }
        Class<?> clazz = new PageParserTest().getClass();
        URL uRL = clazz.getResource("test");
        File file2 = new File(uRL.toURI());
        if (!file2.isDirectory()) {
            systemLog.error(file2 + " is not a directory. This test does not work from within jars. For development, you need to explode the jar");
            return;
        }
        systemLog.bug("Regression test directory: " + file2.getAbsolutePath());
        File[] fileArray = file2.listFiles(new SuffixSelector(".mp"));
        if (fileArray.length == 0) {
            systemLog.warn("No *.mp test files found in directory: ", file2.getAbsolutePath());
        }
        Watch watch = new Watch("parse");
        Watch watch2 = new Watch("compile");
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            PageParser pageParser;
            object = fileArray[i];
            systemLog.bug("Processing file: ", ((File)object).getName());
            n = ((File)object).getName().toLowerCase().startsWith("crap");
            if (n != 0) {
                ++n2;
            }
            objectArray = ((File)object).getName();
            int n4 = objectArray.lastIndexOf(".");
            String string = objectArray.substring(0, n4);
            String string2 = string + ".java";
            File file3 = new File(file2, string2);
            File file4 = new File(file, string2);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            if (bl2) {
                try {
                    charArrayWriter.reset();
                    charArrayWriter.append("Generate: ").append(String.format("%-20s", ((File)object).getName()));
                    watch.start();
                    pageParser = new PageParser(file2, (File)object, file3, string);
                    pageParser.parse();
                    watch.stop();
                    charArrayWriter.append(" [parsed in:").append(String.format("%3s", String.valueOf(watch.getTime()))).append(" ms, ");
                    watch2.start();
                    PageCompiler pageCompiler = new PageCompiler(file3, System.getProperty("java.class.path"), null);
                    boolean bl3 = pageCompiler.compile();
                    watch2.stop();
                    if (!bl3) {
                        charArrayWriter.append(" compile error...possibly expected]");
                        systemLog.bug(pageCompiler.getError());
                    } else {
                        charArrayWriter.append(" compiled in: ").append(String.format("%5s", String.valueOf(watch2.getTime()))).append(" ms]");
                        File file5 = new File(file2, string + ".class");
                        if (file5.exists()) {
                            file5.delete();
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    charArrayWriter.append(" [parse error...possibly expected]");
                    PageParserTest.msg(((File)object).getName(), "Parse Error: " + exception.toString());
                }
                systemLog.info(charArrayWriter.toString());
                continue;
            }
            if (!file3.exists() && n == 0) {
                PageParserTest.msg(((File)object).getName(), "FAILED [expected file: " + file3.getAbsolutePath() + " does not exist]");
                continue;
            }
            pageParser = new PageParser(file2, (File)object, file4, string);
            try {
                pageParser.parse();
                if (!PageParserTest.compare(file3, file4)) {
                    PageParserTest.msg(((File)object).getName(), "FAIL [expected != actual]");
                    continue;
                }
                PageParserTest.msg(((File)object).getName(), "OK");
                continue;
            }
            catch (Exception exception) {
                if (n != 0) {
                    PageParserTest.msg(((File)object).getName(), "OK");
                    continue;
                }
                PageParserTest.msg(((File)object).getName(), "FAIL [ParseException] " + exception.toString());
            }
        }
        if (bl2) {
            System.out.println();
            System.out.println(fileArray.length - n2 + " total (non-crap) *.mp files in " + file2.getAbsolutePath());
            System.out.println(n3 + " expected files were generated.");
        }
        System.out.println();
        TablePrinter.PrintConfig printConfig = new TablePrinter.PrintConfig();
        printConfig.setAutoFit(false).setPrintBorders(true).setCellPadding(1);
        if (bl2) {
            printConfig.setCellWidthForColumn(1, 55);
            System.out.println("The following errors are expected!");
        }
        object = new TablePrinter(2, System.out, printConfig);
        ((TablePrinter)object).startTable();
        for (n = 0; n < results.size(); ++n) {
            ((TablePrinter)object).startRow();
            objectArray = (Object[])results.get(n);
            ((TablePrinter)object).printCell(objectArray[0].toString());
            ((TablePrinter)object).printCell(objectArray[1].toString());
            ((TablePrinter)object).endRow();
        }
        ((TablePrinter)object).endTable();
    }

    static void msg(Object object, Object object2) {
        results.add(new Object[]{object, object2});
    }

    static boolean compare(File file, File file2) throws Exception {
        if (!file2.exists()) {
            return false;
        }
        byte[] byArray = IOUtil.fileToByteArray(file);
        byte[] byArray2 = IOUtil.fileToByteArray(file2);
        return Arrays.equals(byArray, byArray2);
    }
}

