/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import fc.io.SystemLog;
import fc.web.servlet.Action;
import fc.web.servlet.WebUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ActionMgr {
    protected final SystemLog log = Log.getDefault();
    protected final Map actionMap = new HashMap();

    protected ActionMgr() {
    }

    public final void addAction(Action action) {
        String string = action.getName().toLowerCase();
        if (this.actionMap.containsKey(string)) {
            throw new IllegalArgumentException("An action with the name '" + string + " already exists");
        }
        this.actionMap.put(string, action);
        this.log.bug("ActionMgr: installed new action=", string);
    }

    public void handleWebRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.log.bug("enter");
        if (this.log.canLog(SystemLog.DEBUG)) {
            this.log.bug("requested URL=" + WebUtil.getRequestURL(httpServletRequest), "req=", httpServletRequest);
        }
        String string = WebUtil.getRequiredParam(httpServletRequest, "act").toLowerCase();
        Action action = null;
        if (!this.actionMap.containsKey(string)) {
            this.log.warn("Could not find action for action=" + action, "installed actions=", this.actionMap);
            throw new ServletException("ActionMgr: Could not understand the web request, request=" + httpServletRequest);
        }
        action = (Action)this.actionMap.get(string);
        action.handle(httpServletRequest, httpServletResponse);
        this.log.bug("exit");
    }

    public String toString() {
        return this.getClass().getName() + "; actions=" + this.actionMap;
    }
}

