/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import fc.web.servlet.FCBaseServlet;
import fc.web.servlet.WebApp;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminServlet
extends FCBaseServlet {
    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            this.showSQLForm(httpServletRequest, httpServletResponse);
        }
        catch (SQLException sQLException) {
            printWriter.print("<pre>");
            sQLException.printStackTrace(printWriter);
            printWriter.print("</pre>");
            throw new ServletException((Throwable)sQLException);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Object var4_4 = null;
        ServletContext servletContext = this.getServletContext();
        try {
            String string = httpServletRequest.getParameter("log.level");
            if (string != null && !string.equals("n/a")) {
                this.log.bug("Adjusting log level for the application log; new level=", string);
                WebApp.getInstance(this.appName).getAppLog().setLevel(string);
            }
            Map map = WebApp.getInstance((String)this.appName).allServletsMap;
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("servlet.log.") || (string = httpServletRequest.getParameter(string2)) == null || string.equals("n/a")) continue;
                this.log.bug("Adjusting log level for: ", string2, "; new level=", string);
                String string3 = string2.substring(12, string2.length());
                FCBaseServlet fCBaseServlet = (FCBaseServlet)((Object)map.get(string3));
                if (fCBaseServlet == null) {
                    this.log.bug("Error setting new level for", string2, "; log not found in all_logs map");
                    continue;
                }
                Log log = fCBaseServlet.getLog();
                log.setLevel(string);
            }
            this.showSQLForm(httpServletRequest, httpServletResponse);
        }
        catch (SQLException sQLException) {
            printWriter.print("<pre>");
            sQLException.printStackTrace(printWriter);
            printWriter.print("</pre>");
            throw new ServletException((Throwable)sQLException);
        }
    }

    void showSQLForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, SQLException {
        ServletContext servletContext = this.getServletContext();
        String string = httpServletRequest.getServletPath();
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head></head><body bgcolor='#FFFFFF'><center>");
        printWriter.print("<form method=post action=" + string + ">");
        printWriter.println("<h1>Admin Servlet</h1><hr>");
        printWriter.println("<h3>Installed Connection Managers Information</h3>");
        printWriter.println(WebApp.getInstance((String)this.appName).connectionManagers);
        printWriter.println("<hr>");
        printWriter.println("Default Connection Manager");
        printWriter.println(WebApp.getInstance(this.appName).getConnectionMgr());
        printWriter.println("<hr>");
        printWriter.println("<h3>Current Logging Information</h3>");
        printWriter.println("<table border=1>");
        printWriter.println("<tr bgcolor=#cdcdcd><td width=50%><b>Context/Default log</b></td><td>Current Level</td><td>Select a new level</td></tr>");
        Log log = WebApp.getInstance(this.appName).getAppLog();
        printWriter.println("<tr><td>");
        printWriter.println("This is the default log used by the fc framework and by the ServletContext (and stored in the context under the <tt>ContextInit.DEFAULT_LOG_KEY</tt> key)");
        printWriter.println("</td><td>");
        printWriter.println(log.getLevel());
        printWriter.println("</td><td>");
        this.printLogSelect(printWriter, "defaultlog");
        printWriter.println("</td></tr>");
        printWriter.println("<tr><td colspan=3>&nbsp</td></tr>");
        printWriter.println("<tr bgcolor=#cdcdcd><td><b>Per Servlet/JSP logs</b></td><td>Current Level</td><td>Select a new level</td></tr>");
        Map map = WebApp.getInstance((String)this.appName).allServletsMap;
        for (Map.Entry entry : map.entrySet()) {
            FCBaseServlet fCBaseServlet = (FCBaseServlet)((Object)entry.getValue());
            Log log2 = fCBaseServlet.getLog();
            printWriter.print("<tr><td>[<font color=blue>");
            printWriter.print((Object)fCBaseServlet);
            printWriter.print("</font>]<br>");
            printWriter.print(fCBaseServlet.stats());
            printWriter.print("</td><td>");
            printWriter.print(log2.getLevel());
            printWriter.print("</td><td>");
            this.printLogSelect(printWriter, "servlet.log." + ((Object)((Object)fCBaseServlet)).getClass().getName());
            printWriter.println("</td></tr>");
        }
        printWriter.println("</table>");
        printWriter.println("<hr>");
        printWriter.print("<INPUT TYPE=submit name=submit value=submit></INPUT>");
        printWriter.print("</form></center></body></html>");
        printWriter.flush();
    }

    void printLogSelect(PrintWriter printWriter, Object object) {
        printWriter.print("<select name='");
        printWriter.print(object);
        printWriter.print("'>");
        printWriter.println("<option value='n/a'>--[select]--</option>");
        Iterator iterator = this.log.getLevelNames();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            printWriter.print("<option value='");
            printWriter.print(e);
            printWriter.print("'>");
            printWriter.print(e);
            printWriter.println("</option>");
        }
        printWriter.println("</select>");
    }
}

