/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class DebugSessionListener
implements HttpSessionListener,
HttpSessionAttributeListener {
    Log log;

    void initLog(HttpSession httpSession) {
        if (this.log == null) {
            this.log = Log.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        DebugSessionListener debugSessionListener = this;
        synchronized (debugSessionListener) {
            HttpSession httpSession = httpSessionEvent.getSession();
            this.initLog(httpSession);
            this.log.bug("session CREATED=", httpSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        DebugSessionListener debugSessionListener = this;
        synchronized (debugSessionListener) {
            HttpSession httpSession = httpSessionEvent.getSession();
            this.initLog(httpSession);
            this.log.bug("session DESTROYED=", httpSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        DebugSessionListener debugSessionListener = this;
        synchronized (debugSessionListener) {
            HttpSession httpSession = httpSessionBindingEvent.getSession();
            this.initLog(httpSession);
            this.log.bug("attribute ADDED to session=", httpSession, "name=", httpSessionBindingEvent.getName(), "value=", httpSessionBindingEvent.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        DebugSessionListener debugSessionListener = this;
        synchronized (debugSessionListener) {
            HttpSession httpSession = httpSessionBindingEvent.getSession();
            this.initLog(httpSession);
            this.log.bug("attribute REMOVED to session=", httpSession, "name=", httpSessionBindingEvent.getName(), "value=", httpSessionBindingEvent.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        DebugSessionListener debugSessionListener = this;
        synchronized (debugSessionListener) {
            HttpSession httpSession = httpSessionBindingEvent.getSession();
            this.initLog(httpSession);
            this.log.bug("attribute REPLACED to session=", httpSession, "name=", httpSessionBindingEvent.getName(), "value=", httpSessionBindingEvent.getValue());
        }
    }
}

