/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import fc.web.servlet.WebApp;
import fc.web.servlet.WebUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FCBaseServlet
extends HttpServlet {
    private int invokeCount = 0;
    private Date loadTime;
    protected Log log;
    protected String appName;
    protected WebApp app;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        this.loadTime = new Date();
        String string = ((Object)((Object)this)).getClass().getName();
        this.appName = WebUtil.getRequiredParam(servletContext, "appName");
        this.app = WebApp.getInstance(this.appName);
        if (this.app == null) {
            System.out.println("No WebApp installed for this website/context. Calling WebApp related methods will throw an exception...");
            this.log = Log.get(this.appName);
        } else {
            this.log = this.app.getAppLog();
            if (this.app.allServletsMap != null) {
                this.app.allServletsMap.put(((Object)((Object)this)).getClass().getName(), this);
            }
        }
        this.log.info(string, " Finished super.init() in FCBaseServlet");
    }

    protected Connection getConnection(String string) throws SQLException {
        if (this.app == null) {
            throw new RuntimeException("WebApp [" + this.appName + "] is not configured. To use this convenience method, specify a WebApp (that reads property files and creates a connection pool) in your contexts web.xml. Else override this method and/or create a connection yourself.");
        }
        return this.app.getConnection(string);
    }

    protected Connection getConnection() throws SQLException {
        if (this.app == null) {
            throw new RuntimeException("WebApp [" + this.appName + "] is not configured. To use this convenience method, specify a WebApp (that reads property files and creates a connection pool) in your contexts web.xml. Else override this method and/or create a connection yourself.");
        }
        return this.app.getConnection();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ++this.invokeCount;
        super.service(httpServletRequest, httpServletResponse);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Log getLog() {
        return this.log;
    }

    public String stats() {
        return "Invoked: " + this.invokeCount + " times <br>" + "Last loaded at: " + this.loadTime;
    }

    public void destroy() {
        this.log.info((Object)this, "..destroy called");
        if (WebApp.getInstance((String)this.appName).allServletsMap != null) {
            WebApp.getInstance((String)this.appName).allServletsMap.remove(((Object)((Object)this)).getClass().getName());
        }
        this.log.close();
    }
}

