/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import fc.io.SystemLog;
import fc.jdbc.PooledConnection;
import fc.jdbc.QueryUtil;
import fc.jdbc.SimpleConnectionMgr;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.util.ToString;
import fc.web.servlet.SessionUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JDBCSession {
    Log log = Log.get("fc.web.servlet.JDBCSession");
    public static final String SESSIONDATA_TABLE = "sessiondata";
    public static final String SESSIONMASTER_TABLE = "sessionmaster";
    String data_insert;
    String data_update;
    String data_get;
    String data_getall;
    String data_delete;
    String delete_session;
    String expire_session;
    String new_session_with_user;
    String new_session;
    String tie_session_to_user;
    String session_exists;
    String session_for_user;
    String session_access_update;
    boolean deleteExpiredSessions = true;
    int expireSeconds = 28800;
    private static JDBCSession instance;

    private JDBCSession() {
    }

    public static JDBCSession getInstance() {
        return JDBCSession.init(null);
    }

    public static JDBCSession getInstance(Log log) {
        return JDBCSession.init(log);
    }

    private static JDBCSession init(Log log) {
        if (instance != null) {
            return instance;
        }
        instance = new JDBCSession();
        instance.configure(log);
        return instance;
    }

    private void configure(Log log) {
        if (log != null) {
            this.log = log;
        }
        this.data_insert = "insert into sessiondata (session_id, name, value) values (?, ?, ?) ";
        this.data_update = "update sessiondata set value=? where session_id=? and name=?";
        this.data_get = "select sd.name, sd.value from sessiondata as sd, sessionmaster as sma  where sd.session_id=?  and sd.name=?  and sd.session_id = sma.session_id  and sma.is_expired=false";
        this.data_getall = "select name, value from sessiondata where session_id=?";
        this.data_delete = "delete from sessiondata where session_id=? and name=?";
        this.delete_session = "delete from sessionmaster where session_id=? ";
        this.expire_session = "update sessionmaster set is_expired=? where session_id=? ";
        this.new_session_with_user = "insert into sessionmaster (session_id, created, accessed, username) values  (?, ?, ?, ?)";
        this.new_session = "insert into sessionmaster (session_id, created, accessed) values  (?, ?, ?)";
        this.tie_session_to_user = "update sessionmaster set username=? where session_id=?";
        this.session_exists = "select session_id, created, accessed, is_expired from sessionmaster where session_id=?";
        this.session_for_user = "select session_id, created, accessed, is_expired from sessionmaster where username=?";
        this.session_access_update = "update sessionmaster set accessed=? where session_id=?";
    }

    public void setDeleteExpiredSessions(boolean bl) {
        this.deleteExpiredSessions = bl;
    }

    public void create(Connection connection, String string, String string2) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        Argcheck.notnull(string2, "userID argument was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.new_session_with_user);
        preparedStatement.setString(1, string);
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.setTimestamp(3, timestamp);
        preparedStatement.setString(4, string2);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.warn("Query:", preparedStatement, "should have returned 1 but returned:", new Integer(n));
        }
    }

    public void create(Connection connection, String string) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.new_session);
        preparedStatement.setString(1, string);
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        preparedStatement.setTimestamp(2, timestamp);
        preparedStatement.setTimestamp(3, timestamp);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.warn("Query:", preparedStatement, "should have returned 1 but returned:", new Integer(n));
        }
    }

    public void expire(Connection connection, String string) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        PreparedStatement preparedStatement = null;
        if (this.deleteExpiredSessions) {
            preparedStatement = this.prepareStatement(connection, this.delete_session);
            preparedStatement.setString(1, string);
        } else {
            preparedStatement = this.prepareStatement(connection, this.expire_session);
            preparedStatement.setBoolean(1, true);
            preparedStatement.setString(2, string);
        }
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.warn("Query:", preparedStatement, "should have returned 1 but returned: ", new Integer(n), " [This can happen if the sessionID did not exist in the database]");
        }
    }

    public void tieToUser(Connection connection, String string, String string2) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        Argcheck.notnull(string2, "userID arg was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.tie_session_to_user);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.warn("Query:", preparedStatement, " should have returned 1 but returned: ", new Integer(n), " [This can happen if the sessionID did not exist in the database]");
        }
    }

    public void expireInactiveSessions(Connection connection) throws SQLException {
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        String string = null;
        string = this.deleteExpiredSessions ? "delete from sessionmaster where ('" + timestamp + "' + interval '" + this.expireSeconds + "' second ) > accessed " : "update sessionmaster set is_expired=? where (timestamp '" + timestamp + "' + interval '" + this.expireSeconds + "' second ) > accessed ";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setBoolean(1, true);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        this.log.info(new Integer(n), " sessions reaped by: ", string);
    }

    public void setExpireTime(int n) {
        this.expireSeconds = n;
    }

    public int getExpireTime() {
        return this.expireSeconds;
    }

    public boolean exists(Connection connection, String string) throws SQLException {
        boolean bl;
        Argcheck.notnull(string, "sessionID arg was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.session_exists);
        preparedStatement.setString(1, string);
        this.log.bug("Query to run: ", preparedStatement);
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl2 = false;
        if (resultSet.next() && !(bl = resultSet.getBoolean(4))) {
            bl2 = true;
        }
        return bl2;
    }

    public Info sessionInfo(Connection connection, String string) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.session_exists);
        preparedStatement.setString(1, string);
        this.log.bug("Query to run: ", preparedStatement);
        Info info = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            info = new Info();
            info.sessionID = string;
            info.created = resultSet.getTimestamp(2);
            info.accessed = resultSet.getTimestamp(3);
            info.is_expired = resultSet.getBoolean(4);
        }
        return info;
    }

    public List getForUser(Connection connection, String string) throws SQLException {
        if (string == null) {
            this.log.warn("userID arg was null, was this intentional ?");
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.session_for_user);
        preparedStatement.setString(1, string);
        this.log.bug("Query to run: ", preparedStatement);
        ArrayList<Info> arrayList = new ArrayList<Info>();
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Info info = new Info();
            info.sessionID = resultSet.getString(1);
            info.created = resultSet.getTimestamp(2);
            info.accessed = resultSet.getTimestamp(3);
            info.is_expired = resultSet.getBoolean(4);
            arrayList.add(info);
        }
        return arrayList;
    }

    public List getForUser(Connection connection, int n) throws SQLException {
        return this.getForUser(connection, String.valueOf(n));
    }

    public Map getAll(Connection connection, String string) throws SQLException {
        String string2;
        String string3;
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        if (!this.exists(connection, string)) {
            return null;
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_getall);
        preparedStatement.setString(1, string);
        this.log.bug("Query to run: ", preparedStatement);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
            string3 = resultSet.getString(1);
            string2 = resultSet.getString(2);
            hashMap.put(string3, string2);
        }
        while (resultSet.next()) {
            string3 = resultSet.getString(1);
            string2 = resultSet.getString(2);
            hashMap.put(string3, string2);
        }
        if (bl) {
            this.updateSessionAccessTime(connection, string);
        }
        return hashMap;
    }

    public String get(Connection connection, String string, String string2) throws SQLException {
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        Argcheck.notnull(string2, "key argument was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_get);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        this.log.bug("Query to run: ", preparedStatement);
        String string3 = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string3 = resultSet.getString(2);
            this.updateSessionAccessTime(connection, string);
        }
        return string3;
    }

    public void delete(Connection connection, String string, String string2) throws SQLException {
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        Argcheck.notnull(string2, "key argument was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_delete);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n == 0) {
            this.log.warn(preparedStatement, "key=", string2, "[key not deleted, does it exist in the database ?]");
        }
        this.updateSessionAccessTime(connection, string);
    }

    public void add(Connection connection, String string, String string2, String string3) throws SQLException {
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        Argcheck.notnull(string2, "key argument was null");
        if (!this.exists(connection, string)) {
            throw new SQLException("The specified sessionID:[" + string + "] has expired");
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_insert);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.bug("insert error, preparedstatment", preparedStatement, " returned", new Integer(n));
            throw new SQLException("Error saving data, inserted row count != 1");
        }
        this.updateSessionAccessTime(connection, string);
    }

    public void addAll(Connection connection, String string, Map map) throws SQLException {
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        Argcheck.notnull(map, "data argument was null");
        Set set = map.entrySet();
        int n = set.size();
        if (n == 0) {
            this.log.warn("nothing to do, map contains no data");
            return;
        }
        if (!this.exists(connection, string)) {
            throw new SQLException("The specified sessionID:[" + string + "] has expired");
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_insert);
        for (Map.Entry object2 : set) {
            String string2 = object2.getKey().toString();
            String string3 = object2.getValue().toString();
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.addBatch();
        }
        this.log.bug("Query to run: ", preparedStatement);
        int[] nArray = preparedStatement.executeBatch();
        this.updateSessionAccessTime(connection, string);
    }

    public void put(Connection connection, String string, String string2, String string3) throws SQLException {
        this.add(connection, string, string2, string3);
    }

    public void putAll(Connection connection, String string, Map map) throws SQLException {
        this.addAll(connection, string, map);
    }

    public String update(Connection connection, String string, String string2, String string3) throws SQLException {
        Argcheck.notnull(connection, "con argument was null");
        Argcheck.notnull(string, "sessionID argument was null");
        Argcheck.notnull(string2, "key argument was null");
        if (!this.exists(connection, string)) {
            throw new SQLException("The specified sessionID:[" + string + "] has expired");
        }
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.data_update);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        this.log.bug("Query to run: ", preparedStatement);
        String string4 = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string4 = resultSet.getString(2);
            this.updateSessionAccessTime(connection, string);
        }
        return string4;
    }

    private void updateSessionAccessTime(Connection connection, String string) throws SQLException {
        Argcheck.notnull(string, "sessionID arg was null");
        PreparedStatement preparedStatement = this.prepareStatement(connection, this.session_access_update);
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setString(2, string);
        this.log.bug("Query to run: ", preparedStatement);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            this.log.warn("Query:", preparedStatement, "should have returned 1 but returned", new Integer(n), "[This can happen if the sessionID did not exist in the database]");
        }
    }

    private final PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        if (!(connection instanceof PooledConnection)) {
            return connection.prepareStatement(string);
        }
        PooledConnection pooledConnection = (PooledConnection)connection;
        PreparedStatement preparedStatement = pooledConnection.getCachedPreparedStatement(string);
        return preparedStatement;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        Args args = new Args(stringArray);
        args.setUsage("java fc.web.servlet.JDBCSession -conf conf-file [-loglevel level]\n-test  [tests the database for session tables]\n   -- or --\n-create  [creates session tables in the database]\n   -userTableName=<name of Users table in the database> \n   -userIDColName=the name of username/userid column in Users table.)] \n");
        if (args.flagExists("loglevel")) {
            string = args.get("loglevel");
            Log.getDefault().setLevel(string);
        }
        string = args.getRequired("conf");
        FilePropertyMgr filePropertyMgr = new FilePropertyMgr(new File(string));
        SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(filePropertyMgr);
        String string2 = filePropertyMgr.get("jdbc.url");
        boolean bl = false;
        if (string2.indexOf("mysql") != -1) {
            bl = true;
        }
        Connection connection = simpleConnectionMgr.getConnection();
        if (args.flagExists("test")) {
            JDBCSession.test(connection);
        } else if (args.flagExists("create")) {
            String string3 = args.get("userTableName", "users");
            JDBCSession.createJDBCTables(connection, string3, bl);
        } else {
            args.showError();
        }
        connection.close();
    }

    public static void createJDBCTables(Connection connection, String string, boolean bl) throws Exception {
        Argcheck.notnull(connection, "connection param was null");
        Argcheck.notnull(string, "userTableName param was null");
        SystemLog systemLog = Log.getDefault();
        try {
            QueryUtil.startTransaction(connection);
            Statement statement = null;
            String string2 = null;
            string2 = "create table sessiondata ( session_id varchar(50), name  varchar(100) not null, value text )";
            statement = connection.createStatement();
            systemLog.info("Running: " + string2);
            statement.execute(string2);
            string2 = "create INDEX IDX_sessiondata ON sessiondata(session_id)";
            statement = connection.createStatement();
            systemLog.info("Running: " + string2);
            statement.execute(string2);
            string2 = "create table sessionmaster ( session_id  \tvarchar(50) primary key,  created  \t\ttimestamp not null, accessed  \t\ttimestamp not null," + (bl ? " is_expired \tbool default 0," : " is_expired\tbool default 'f',") + " username \t\tvarchar(255)" + " )";
            statement = connection.createStatement();
            systemLog.info("Running: " + string2);
            statement.execute(string2);
            string2 = "create INDEX IDX_sessionmaster_1 ON sessionmaster(username)";
            statement = connection.createStatement();
            systemLog.info("Running: " + string2);
            statement.execute(string2);
            string2 = "alter table sessiondata add \n FOREIGN KEY (session_id) REFERENCES sessionmaster (session_id)  on delete cascade ";
            statement = connection.createStatement();
            systemLog.info("Running: " + string2);
            statement.execute(string2);
            QueryUtil.endTransaction(connection);
        }
        catch (Exception exception) {
            QueryUtil.abortTransaction(connection);
            systemLog.error("*** JDBC SESSION TABLES WERE NOT CREATED PROPERLY (IF AT ALL)****");
            throw exception;
        }
        systemLog.info("*** JDBC SESSION TABLE SUCCESSFULLY CREATED ***");
    }

    static void test(Connection connection) throws Exception {
        long l = 0L;
        String string = null;
        try {
            SystemLog systemLog = Log.getDefault();
            JDBCSession jDBCSession = JDBCSession.getInstance(systemLog);
            String string2 = SessionUtil.newSessionID();
            System.out.println(">>>creating new session");
            jDBCSession.create(connection, string2);
            System.out.println("....done");
            System.out.println(">>>session exists ?");
            System.out.println(jDBCSession.exists(connection, string2));
            System.out.println(">>>session info");
            System.out.println(jDBCSession.sessionInfo(connection, string2));
            System.out.println(">>>expiring session");
            jDBCSession.expire(connection, string2);
            System.out.println(">>>session info");
            System.out.println(jDBCSession.sessionInfo(connection, string2));
            System.out.println(">>>session exists ?");
            System.out.println(jDBCSession.exists(connection, string2));
            System.out.println(">>>creating another session");
            string2 = SessionUtil.newSessionID();
            jDBCSession.create(connection, string2);
            System.out.println("....done");
            System.out.println(">>>session info");
            System.out.println(jDBCSession.sessionInfo(connection, string2));
            System.out.println(">>>setting session expire seconds to 5 seconds");
            jDBCSession.setExpireTime(5);
            System.out.println(">>>set delete expired seconds to false");
            jDBCSession.setDeleteExpiredSessions(false);
            System.out.println(">>>sleeping 5 seconds");
            Thread.currentThread();
            Thread.sleep(5000L);
            System.out.println(">>>expiring all invalid sessions...");
            jDBCSession.expireInactiveSessions(connection);
            System.out.println(">>>adding value foo=bar to an expired session");
            try {
                jDBCSession.add(connection, string2, "foo", "bar");
            }
            catch (SQLException sQLException) {
                System.out.println("Expecting the following exception");
                sQLException.printStackTrace();
            }
            System.out.println(">>>getting value for foo");
            for (int i = 0; i < 10; ++i) {
                l = System.currentTimeMillis();
                string = jDBCSession.get(connection, string2, "foo");
                System.out.println("time: " + (System.currentTimeMillis() - l) + " ms");
            }
            System.out.println(string);
            string2 = SessionUtil.newSessionID();
            jDBCSession.create(connection, string2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("foo2", "bar2");
            hashMap.put("foo3", "bar3");
            System.out.println(">>>adding map " + hashMap);
            jDBCSession.addAll(connection, string2, hashMap);
            System.out.println(">>>getting all values");
            System.out.println(jDBCSession.getAll(connection, string2));
            System.out.println(">>> tie session to user");
            jDBCSession.tieToUser(connection, string2, "1");
            System.out.println(">>> session for userID=1");
            l = System.currentTimeMillis();
            List list = jDBCSession.getForUser(connection, 1);
            System.out.println("time: " + (System.currentTimeMillis() - l) + " ms");
            System.out.println(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Info {
        String sessionID;
        Timestamp created;
        Timestamp accessed;
        boolean is_expired;
        private ToString tostr = new ToString((Object)this, ToString.Style.VisibleLevel.DEFAULT);

        public String getSessionID() {
            return this.sessionID;
        }

        public Timestamp getCreated() {
            return this.created;
        }

        public Timestamp getAccessed() {
            return this.accessed;
        }

        public boolean getIsExpired() {
            return this.is_expired;
        }

        public String toString() {
            return this.tostr.reflect().render();
        }
    }
}

