/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.jdbc.QueryUtil;
import fc.web.servlet.FCBaseServlet;
import fc.web.servlet.WebApp;
import fc.web.servlet.WebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RawSQLServlet
extends FCBaseServlet {
    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = WebUtil.getRequiredParam((Servlet)this, "enable");
        if (!string.equalsIgnoreCase("true")) {
            throw new UnavailableException("Cannot run RawSQLServlet because the 'enable' init paramter was not set to true");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            this.showSQLForm(httpServletRequest, httpServletResponse);
        }
        catch (SQLException sQLException) {
            printWriter.print("<B> SQL Error:</B>\n" + sQLException);
            printWriter.print("<pre>");
            sQLException.printStackTrace(printWriter);
            printWriter.print("</pre>");
            throw new ServletException((Throwable)sQLException);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        Connection connection = null;
        try {
            String string = httpServletRequest.getParameter("sql");
            if (string == null) {
                this.showSQLForm(httpServletRequest, httpServletResponse);
                return;
            }
            if (string == null) {
                printWriter.println("<b>Error: malformed query, contact administrator</b>");
                QueryUtil.close(null, null, connection);
                return;
            }
            long l = System.currentTimeMillis();
            connection = this.getConnection();
            Statement statement = connection.createStatement();
            printWriter.println("<html><head>");
            printWriter.println("<style type=\"text/css\">");
            printWriter.println(".QueryUtil_Table { padding: 2px; border: 1px solid #660000; }");
            printWriter.println(".QueryUtil_HeaderCell { border: 1px solid; background: red; }");
            printWriter.println(".QueryUtil_Cell { border: 1px solid; }");
            printWriter.println("</style>");
            printWriter.println("</head><body bgcolor='#FFFFFF'><center>");
            printWriter.print("<h2>Query</h2><blockquote><pre>");
            printWriter.print(string);
            printWriter.println("</pre></blockquote>");
            ResultSet resultSet = statement.executeQuery(string);
            long l2 = System.currentTimeMillis() - l;
            printWriter.println("<p><h2>Results</h2>");
            QueryUtil.printResultSetHTMLTable(resultSet, printWriter, QueryUtil.ResultSetPrintDirection.HORIZONTAL);
            printWriter.println("<hr>");
            printWriter.print("Query time: ");
            printWriter.println(this.formatTime(l2));
            printWriter.println("<hr>");
            this.printConInfo(printWriter, connection);
            printWriter.println("</body></html>");
            QueryUtil.close(null, null, connection);
        }
        catch (SQLException sQLException) {
            printWriter.print("<B> SQL Error:</B>\n" + sQLException);
            printWriter.print("<pre>");
            sQLException.printStackTrace(printWriter);
            printWriter.print("</pre>");
            throw new ServletException((Throwable)sQLException);
        }
        finally {
            QueryUtil.close(null, null, connection);
        }
    }

    void showSQLForm(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, SQLException {
        String string = httpServletRequest.getServletPath();
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head></head><body bgcolor='#FFFFFF'><center>");
        printWriter.println("<h1>Raw SQL Servlet</h1><hr>");
        printWriter.println("<h2>Connection Information</h2>");
        this.printJDBCInfo(printWriter);
        printWriter.println("<h2>Enter a SQL Query</h2><hr>");
        printWriter.print("<form method=post action=" + string + ">");
        printWriter.print("<textarea rows=10 cols=50 name=sql>");
        printWriter.print("</textarea><br>");
        printWriter.print("<INPUT TYPE=submit name=submit value=submit></INPUT>");
        printWriter.print("</form></center></body></html>");
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printJDBCInfo(PrintWriter printWriter) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            printWriter.println("<table border=1 bordercolor=#3f6c96 cellpadding=4 cellspacing=0>");
            printWriter.println("<tr><td align=right>");
            printWriter.println("Driver ");
            printWriter.println("</td>");
            printWriter.println("<td align=left>");
            printWriter.println(WebApp.getInstance(this.appName).getConnectionMgr().getDriver());
            printWriter.println("</td></tr>");
            printWriter.println("<tr><td align=right>");
            printWriter.println("Catalog ");
            printWriter.println("</td>");
            printWriter.println("<td align=left>");
            printWriter.println(connection.getCatalog());
            printWriter.println("</td></tr>");
            printWriter.println("<tr><td align=right>");
            printWriter.println("Autocommit ");
            printWriter.println("</td>");
            printWriter.println("<td align=left>");
            printWriter.println(connection.getAutoCommit());
            printWriter.println("</td></tr>");
            printWriter.println("<tr><td align=right>");
            printWriter.println("Transaction isolation ");
            printWriter.println("</td>");
            printWriter.println("<td align=left>");
            printWriter.println(connection.getTransactionIsolation());
            printWriter.println("</td></tr>");
            printWriter.println("</table>");
        }
        finally {
            QueryUtil.close(null, null, connection);
        }
    }

    void printConInfo(PrintWriter printWriter, Connection connection) throws SQLException {
        printWriter.println("<table border=0>");
        SQLWarning sQLWarning = connection.getWarnings();
        printWriter.println("<tr><td align=right>");
        printWriter.println("SQL Warnings: ");
        printWriter.println("</td>");
        printWriter.println("<td align=left>");
        if (sQLWarning == null) {
            printWriter.println("None");
        } else {
            printWriter.println(sQLWarning);
            while (sQLWarning.getNextWarning() != null) {
                printWriter.println("<br>");
                printWriter.println(sQLWarning);
            }
        }
        printWriter.println("</td></tr>");
        printWriter.println("</table>");
    }

    String formatTime(long l) {
        if (l < 1000L) {
            return l + " ms";
        }
        return l % 1000L + " seconds";
    }
}

