/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.util.UUIDUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SessionUtil {
    static final String TestCookieName = "eikooc";

    public static void setTestCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie(TestCookieName, "scotchAndsoda");
        cookie.setMaxAge(-1);
        httpServletResponse.addCookie(cookie);
    }

    public static boolean hasTestCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return false;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(TestCookieName)) continue;
            return true;
        }
        return false;
    }

    public static void deleteTestCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(TestCookieName)) continue;
            cookieArray[i].setMaxAge(0);
            httpServletResponse.addCookie(cookieArray[i]);
            break;
        }
    }

    public static String newSessionID() {
        return UUIDUtil.newSessionID();
    }
}

