/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class WebUtil {
    static final Log log = Log.get("fc.web.servlet");
    private static final String confirm = "confirm";
    private static final String cancel = "cancel";

    public static final String getRequiredParam(ServletContext servletContext, String string) throws ServletException {
        String string2 = servletContext.getInitParameter(string);
        if (string2 == null) {
            String string3 = "Required Servlet Init Parameter: '" + string + "' was not found";
            log.error(string3);
            throw new UnavailableException(string3);
        }
        return string2;
    }

    public static final String getParam(ServletContext servletContext, String string, String string2) {
        String string3 = servletContext.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static final String getRequiredParam(Servlet servlet, String string) throws ServletException {
        ServletConfig servletConfig = servlet.getServletConfig();
        String string2 = servletConfig.getInitParameter(string);
        if (string2 == null) {
            String string3 = "Required Servlet Init Parameter: '" + string + "' for servlet '" + servletConfig.getServletName() + "' was not found";
            log.error(string3);
            throw new UnavailableException(string3);
        }
        return string2;
    }

    public static final String getParam(Servlet servlet, String string, String string2) {
        ServletConfig servletConfig = servlet.getServletConfig();
        String string3 = servletConfig.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static final String getRequiredParam(HttpServletRequest httpServletRequest, String string) throws ServletException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            String string3 = "Required Parameter: '" + string + "' was not found";
            log.error(string3);
            throw new ServletException(string3);
        }
        return string2;
    }

    public static final String getParam(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3 = httpServletRequest.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static final boolean isSelected(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        return string2 != null && !string2.equals("");
    }

    public static final boolean getBooleanParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        return Boolean.parseBoolean(string2);
    }

    public static final Object getRequiredAttribute(ServletContext servletContext, String string) throws ServletException {
        Object object = servletContext.getAttribute(string);
        if (object == null) {
            String string2 = "Required context attribute: '" + string + "' was not found";
            log.error(string2);
            throw new UnavailableException(string2);
        }
        return object;
    }

    public static final Object getAttribute(ServletContext servletContext, String string, String string2) throws ServletException {
        Object object = servletContext.getAttribute(string);
        if (object != null) {
            return object;
        }
        return string2;
    }

    public static final Object getRequiredAttribute(HttpServletRequest httpServletRequest, String string) throws ServletException {
        Object object = httpServletRequest.getAttribute(string);
        if (object == null) {
            String string2 = "Required Parameter: '" + string + "' was not found";
            log.error(string2);
            throw new ServletException(string2);
        }
        return object;
    }

    public static final Object getAttribute(HttpServletRequest httpServletRequest, String string, String string2) throws ServletException {
        Object object = httpServletRequest.getAttribute(string);
        if (object != null) {
            return object;
        }
        return string2;
    }

    public static final String getSessionString(HttpSession httpSession, String string) {
        Object object = httpSession.getAttribute(string);
        if (object != null) {
            return (String)object;
        }
        return null;
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(string)) continue;
            return cookieArray[i];
        }
        return null;
    }

    public static final void forward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string);
        if (log.canLog(Log.DEBUG)) {
            StringBuffer stringBuffer = WebUtil.getRequestURL(httpServletRequest);
            log.bug(stringBuffer, "forwarding to page: ", string);
        }
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public static final void clientRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException, IOException {
        String string2 = httpServletResponse.encodeRedirectURL(WebUtil.absolutePath(httpServletRequest, string));
        if (log.canLog(Log.DEBUG)) {
            StringBuffer stringBuffer = WebUtil.getRequestURL(httpServletRequest);
            log.bug(stringBuffer, "redirecting to page: ", string2);
        }
        httpServletResponse.sendRedirect(string2);
    }

    public static final String absolutePath(HttpServletRequest httpServletRequest, String string) {
        return httpServletRequest.getContextPath() + string;
    }

    public static final String absoluteEncPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        return httpServletResponse.encodeURL(WebUtil.absolutePath(httpServletRequest, string));
    }

    public static final StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            stringBuffer.append('?');
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static final boolean requestCancelled(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(cancel);
        return string != null;
    }

    public static final boolean requestConfirmed(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(confirm);
        return string != null;
    }

    public static final void debugRequestParams(HttpServletRequest httpServletRequest) {
        WebUtil.debugRequestParams(httpServletRequest, System.out);
    }

    public static final void debugRequestParams(HttpServletRequest httpServletRequest, OutputStream outputStream) {
        System.out.print("Request params/");
        System.out.print(Thread.currentThread().getName());
        System.out.print(" ");
        Iterator iterator = httpServletRequest.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.out.print(entry.getKey());
            System.out.print(":");
            System.out.print(Arrays.toString((String[])entry.getValue()));
            if (iterator.hasNext()) {
                System.out.print(", ");
                continue;
            }
            System.out.println();
        }
    }

    public static final void setExpireHeaders(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        httpServletResponse.addHeader("Cache-Control", "post-check=0, pre-check=0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Expires", "-1");
    }

    public static Map parseQuery(String string) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf("=");
            hashMap.put(URLDecoder.decode(string2.substring(0, n), "UTF-8"), URLDecoder.decode(string2.substring(n + 1), "UTF-8"));
        }
        return hashMap;
    }

    public static boolean isMobileClient(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("user-agent");
        return string != null && string.indexOf("obile") > 0;
    }

    public static boolean isIOSClient(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("user-agent");
        return string != null && string.indexOf("obile") > 0 && string.indexOf("afari") > 0;
    }
}

