/*
 * Decompiled with CFR 0.152.
 */
package fc.web.simpleforms;

import fc.io.Log;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Errors {
    Log log = Log.getDefault();
    List formErrors;
    Map fieldErrors;
    List formWarnings;
    Map fieldWarnings;

    public void addFormError(String string) {
        if (this.formErrors == null) {
            this.formErrors = new ArrayList();
        }
        this.formErrors.add(string);
    }

    public void addFieldError(String string, Object object) {
        Object object2;
        if (this.fieldErrors == null) {
            this.fieldErrors = new HashMap();
        }
        if ((object2 = this.fieldErrors.put(string, object)) != null) {
            this.log.warn("Use a list to add more than 1 message. I am currently over-writing the previous error message for field: " + string + " [old msg=" + object2 + "] [new msg=" + object + "]");
        }
    }

    public void addFormWarning(String string) {
        if (this.formWarnings == null) {
            this.formWarnings = new ArrayList();
        }
        this.formWarnings.add(string);
    }

    public void addFieldWarning(String string, Object object) {
        Object object2;
        if (this.fieldWarnings == null) {
            this.fieldWarnings = new HashMap();
        }
        if ((object2 = this.fieldWarnings.put(string, object)) != null) {
            this.log.warn("Use a list to add more than 1 warning. I am currently over-writing the previous warning message for field: " + string + " [old msg=" + object2 + "] [new msg=" + object + "]");
        }
    }

    public List getFormErrors() {
        return this.formErrors;
    }

    public Object getFieldError(String string) {
        if (this.fieldErrors == null) {
            return null;
        }
        return this.fieldErrors.get(string);
    }

    public List getFormWarnings() {
        return this.formWarnings;
    }

    public Object getFieldWarning(String string) {
        return this.fieldWarnings.get(string);
    }

    public boolean hasError() {
        return this.formErrors != null || this.fieldErrors != null;
    }

    public boolean hasWarning() {
        return this.formWarnings != null || this.fieldWarnings != null;
    }

    public boolean hasWarning(String string) {
        return this.fieldWarnings != null && this.fieldWarnings.containsKey(string);
    }

    public void renderFormErrors(Writer writer) throws IOException {
        if (this.formErrors == null) {
            return;
        }
        if (this.formErrors == null) {
            return;
        }
        writer.write("<div class='form-errmsg'>");
        writer.write("\n<ul>");
        for (int i = 0; i < this.formErrors.size(); ++i) {
            Object e = this.formErrors.get(i);
            writer.write("<li>");
            writer.write(String.valueOf(e));
            writer.write("</li>\n");
        }
        writer.write("</ul>\n");
        writer.write("</div>");
    }

    public void render(Writer writer, String string) throws IOException {
        if (this.fieldErrors == null) {
            return;
        }
        Object v = this.fieldErrors.get(string);
        if (v == null) {
            return;
        }
        writer.write("<span class='field-errmsg'>");
        writer.write(String.valueOf(v));
        writer.write("</span>");
        writer.write("<br>");
    }

    public void render(Writer writer, String string, String string2, String string3) throws IOException {
        if (this.fieldErrors == null) {
            return;
        }
        Object v = this.fieldErrors.get(string);
        if (v == null) {
            return;
        }
        writer.write("<span class='field-errmsg'>");
        writer.write(String.valueOf(v));
        writer.write(string2);
        writer.write("</span>");
        writer.write(string3);
    }

    public static void main(String[] stringArray) throws Exception {
        Errors errors = new Errors();
        errors.addFieldError("a", "some field error");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("item1");
        arrayList.add("item2");
        errors.addFieldError("b", arrayList);
        System.out.println("Has warnings: [should be false]: " + errors.hasWarning());
        System.out.println("Has errors: [should be true]:    " + errors.hasError());
        errors.addFormError("some form error");
        System.out.println("Has errors: [should be true]:    " + errors.hasError());
        PrintWriter printWriter = new PrintWriter(System.out);
        printWriter.println("\n--------- form errors ---------");
        errors.renderFormErrors(printWriter);
        printWriter.println("\n--------- field errors [a]--------");
        errors.render(printWriter, "a");
        printWriter.println("\n--------- field errors [b]--------");
        errors.render(printWriter, "b");
        printWriter.println("\n--------- field errors [c/non-existent]--------");
        errors.render(printWriter, "c");
        printWriter.flush();
    }
}

