/*
 * Decompiled with CFR 0.152.
 */
package fc.web.simpleforms;

import fc.util.HTMLUtil;
import fc.web.simpleforms.SelectOption;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public final class State {
    private static final boolean dbg = false;
    private static final String[] str_arr_type = new String[0];
    private static final String cleared_key = "_fc.web.simpleforms.cleared";
    private static final String disabled_key = "_fc.web.simpleforms.disabled";

    private static final String getParameter(HttpServletRequest httpServletRequest, String string) {
        Object object;
        if (httpServletRequest.getAttribute(cleared_key) == null && (object = httpServletRequest.getParameter(string)) != null) {
            return object;
        }
        object = httpServletRequest.getAttribute(string);
        try {
            return (String)object;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("The value of this field [" + string + "] should be set ONLY once (and as a string). You cutting'n'pasting dude ?");
        }
    }

    private static final String[] getParameterValues(HttpServletRequest httpServletRequest, String string) {
        Object object;
        if (httpServletRequest.getAttribute(cleared_key) == null && (object = httpServletRequest.getParameterValues(string)) != null) {
            return object;
        }
        object = httpServletRequest.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String[] stringArray = new String[]{(String)object};
            return stringArray;
        }
        ArrayList arrayList = (ArrayList)object;
        return arrayList.toArray(str_arr_type);
    }

    public static final String text(HttpServletRequest httpServletRequest, String string) {
        String string2 = State.getParameter(httpServletRequest, string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public static final String textarea(HttpServletRequest httpServletRequest, String string) {
        return State.text(httpServletRequest, string).trim();
    }

    public static final String password(HttpServletRequest httpServletRequest, String string) {
        return State.text(httpServletRequest, string);
    }

    public static final String radio(HttpServletRequest httpServletRequest, String string, boolean bl) {
        String string2 = State.getParameter(httpServletRequest, string);
        if (string2 == null) {
            if (bl) {
                return "checked";
            }
            return "";
        }
        return "checked";
    }

    public static final String radio(HttpServletRequest httpServletRequest, String string) {
        return State.radio(httpServletRequest, string, false);
    }

    public static final String radiogroup(HttpServletRequest httpServletRequest, String string, String string2) {
        String[] stringArray = State.getParameterValues(httpServletRequest, string);
        if (stringArray == null) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2) && !stringArray[i].equalsIgnoreCase("on")) continue;
            return "checked";
        }
        return "";
    }

    public static final String checkbox(HttpServletRequest httpServletRequest, String string) {
        String string2 = State.getParameter(httpServletRequest, string);
        if (string2 == null) {
            return "";
        }
        return "checked";
    }

    public static final String checkboxgroup(HttpServletRequest httpServletRequest, String string, String string2) {
        String[] stringArray = State.getParameterValues(httpServletRequest, string);
        if (stringArray == null) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return "checked";
        }
        return "";
    }

    public static final String hidden(HttpServletRequest httpServletRequest, String string) {
        return State.text(httpServletRequest, string);
    }

    public static final String select(HttpServletRequest httpServletRequest, String string, String string2) {
        String[] stringArray = State.getParameterValues(httpServletRequest, string);
        if (stringArray == null) {
            return "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return "selected";
        }
        return "";
    }

    public static void makeOptions(PrintWriter printWriter, HttpServletRequest httpServletRequest, String string, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SelectOption selectOption = (SelectOption)list.get(i);
            String string2 = HTMLUtil.quoteToEntity(selectOption.getHTML());
            String string3 = selectOption.getValue();
            String string4 = HTMLUtil.quoteToEntity(string3);
            printWriter.print("<option val='");
            printWriter.print(string4);
            printWriter.print("'");
            printWriter.print(selectOption.selected() ? " selected " : " ");
            printWriter.print(State.select(httpServletRequest, string, string3));
            printWriter.print(">");
            printWriter.print(string2);
            if (i + 1 >= n) continue;
            printWriter.print("\n");
        }
    }

    public static String makeOptions(HttpServletRequest httpServletRequest, String string, List list) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder(n * 32);
        for (int i = 0; i < n; ++i) {
            SelectOption selectOption = (SelectOption)list.get(i);
            String string2 = HTMLUtil.quoteToEntity(selectOption.getHTML());
            String string3 = selectOption.getValue();
            String string4 = HTMLUtil.quoteToEntity(string3);
            stringBuilder.append("<option val='");
            stringBuilder.append(string4);
            stringBuilder.append("'");
            stringBuilder.append(selectOption.selected() ? " selected " : " ");
            stringBuilder.append(State.select(httpServletRequest, string, string3));
            stringBuilder.append(">");
            stringBuilder.append(string2);
            if (i + 1 >= n) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final void set(HttpServletRequest httpServletRequest, String string, String string2) {
        Object object = httpServletRequest.getAttribute(string);
        if (object == null) {
            httpServletRequest.setAttribute(string, (Object)string2);
            return;
        }
        if (object instanceof String) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object);
            arrayList.add(string2);
            httpServletRequest.setAttribute(string, arrayList);
        } else if (object instanceof ArrayList) {
            ((ArrayList)object).add(string2);
        } else {
            throw new IllegalArgumentException("Only strings can be added. You are trying to add: " + object + "/" + object.getClass().getName());
        }
    }

    public static final void clear(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            httpServletRequest.removeAttribute((String)enumeration.nextElement());
        }
        httpServletRequest.setAttribute(cleared_key, (Object)"");
    }

    public static final String escapedText(HttpServletRequest httpServletRequest, String string) {
        return HTMLUtil.quoteToEntity(State.text(httpServletRequest, string));
    }

    public static final String escapedPassword(HttpServletRequest httpServletRequest, String string) {
        return HTMLUtil.quoteToEntity(State.password(httpServletRequest, string));
    }

    public static final String escapedHidden(HttpServletRequest httpServletRequest, String string) {
        return HTMLUtil.quoteToEntity(State.hidden(httpServletRequest, string));
    }

    public static final void setDisabled(HttpServletRequest httpServletRequest, String string) {
        HashSet<String> hashSet = (HashSet<String>)httpServletRequest.getAttribute(disabled_key);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            httpServletRequest.setAttribute(disabled_key, hashSet);
        }
        hashSet.add(string);
    }

    public static final boolean getDisabled(HttpServletRequest httpServletRequest, String string) {
        Set set = (Set)httpServletRequest.getAttribute(disabled_key);
        if (set == null) {
            return false;
        }
        return set.contains(string);
    }

    public static final String disabled(HttpServletRequest httpServletRequest, String string) {
        if (State.getDisabled(httpServletRequest, string)) {
            return "disabled";
        }
        return "";
    }
}

