/*
 * Decompiled with CFR 0.152.
 */
package fc.web.simpleforms;

import java.util.regex.Pattern;

public final class Valid {
    static final boolean dbg = false;
    static boolean trim = true;
    private static final String intOnlyRE_str = "\\s*\\d*\\s*";
    private static final Pattern intOnlyRE = Pattern.compile("\\s*\\d*\\s*");
    private static final String isFloatOnlyRE_str = "\\s*-?\\d*\\.?\\d*\\s*";
    private static final Pattern isFloatOnlyRE = Pattern.compile("\\s*-?\\d*\\.?\\d*\\s*");
    private static int _badcount = 0;

    public static void setTrimSpaces(boolean bl) {
        trim = bl;
    }

    public static boolean isIntegerOnly(String string) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        return intOnlyRE.matcher(string).matches();
    }

    public static boolean isFloatOnly(String string) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        return isFloatOnlyRE.matcher(string).matches();
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        return string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        return string.length() != 0;
    }

    public static boolean length(String string, int n, int n2) {
        int n3;
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        return (n3 = string.length()) >= n && n3 <= n2;
    }

    public static boolean isAllowed(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < string2.length(); ++j) {
                char c2 = string2.charAt(j);
                if (c != c2) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotAllowed(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (trim) {
            string = string.trim();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = true;
            for (int j = 0; j < string2.length(); ++j) {
                char c2 = string2.charAt(j);
                if (c != c2) continue;
                bl = false;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Valid.p("Valid.isIntegerOnly(\" 3243 \")", Valid.isIntegerOnly(" 3243 "), true);
        Valid.p("Valid.isIntegerOnly(\" 3243. \")", Valid.isIntegerOnly(" 3243. "), false);
        Valid.p("Valid.isFloatOnly(\" 3243. \")", Valid.isFloatOnly(" 3243. "), true);
        Valid.p("Valid.isFloatOnly(\" -3243. \")", Valid.isFloatOnly(" -3243. "), true);
        Valid.p("Valid.isFloatOnly(\" -3243.003 \")", Valid.isFloatOnly(" -3243.003 "), true);
        Valid.p("Valid.isFloatOnly(\".3243.0\")", Valid.isFloatOnly(".3243.0"), false);
        Valid.p("Valid.isFloatOnly(\"-32dd43.003\")", Valid.isFloatOnly("-32dd43.003"), false);
        Valid.p("Valid.isEmpty(\"  \")", Valid.isEmpty("  "), true);
        Valid.p("Valid.isEmpty(\"\")", Valid.isEmpty(""), true);
        Valid.p("Valid.length(\" abc  \", 1, 3)", Valid.length(" abc  ", 1, 3), true);
        Valid.setTrimSpaces(false);
        Valid.p("Valid.length(\" abc  \", 1, 3)", Valid.length(" abc  ", 1, 3), false);
        Valid.setTrimSpaces(true);
        Valid.p("Valid.isAllowed\"abc\", \"abc\")", Valid.isAllowed("abc", "abc"), true);
        Valid.p("Valid.isAllowed(\"abc\", \"abcdef\")", Valid.isAllowed("abc", "abcdef"), true);
        Valid.p("Valid.isAllowed(\"abc\", \"ab\")", Valid.isAllowed("abc", "ab"), false);
        Valid.p("Valid.isAllowed(\"abc\", \"\")", Valid.isAllowed("abc", ""), false);
        Valid.p("Valid.isNotAllowed(\"abc\", \"4\")", Valid.isNotAllowed("abc", "4"), true);
        Valid.p("Valid.isNotAllowed(\"abc\", \"#!@9\")", Valid.isNotAllowed("abc", "#!@9"), true);
        Valid.p("Valid.isNotAllowed(\"abc4\", \"\")", Valid.isNotAllowed("abc4", ""), true);
        Valid.p("Valid.isNotAllowed(\"abc4\", \"a\")", Valid.isNotAllowed("abc4", "a"), false);
        if (_badcount == 0) {
            System.out.println("All internal tests were successful..");
        } else {
            System.out.println(_badcount + " tests failed..");
        }
    }

    private static void p(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            ++_badcount;
            System.out.println("FAILED: " + string);
        }
    }
}

