#!/bin/bash

#Madness, osx 'xargs' and gnu 'xargs' differ. We normalize below 
gnu_xargs=$(xargs --help 2>/dev/null | grep max-lines)
if [ ! -z "$gnu_xargs" ]; then
	xargs_opt="-l1";
else
	xargs_opt="-L 1";
fi

SRC="$(dirname $0)"
cd "$SRC"
SRC="$PWD"

COMPILED="${SRC}/../compiled"

dirs="
io
jdbc
jdbc/dbo
net
util
util/cache
util/pagetemplate
web/forms
web/simpleforms
web/page
web/servlet
"

echo "Compiling all files in the distibution..."; 
echo "Compiled files will be placed in destination: $COMPILED";
echo "";

echo -n "First..deleting any pre-existing compiled classes from destination...";
find "$SRC" -name '*.class' | xargs $xargs_opt rm -f
echo "done."

echo "========================================================================="
echo "All of the following 'Note: ' messages/warnings are java compiler/generics"
echo "related and are totally meaningless. Ignore these warnings (we do not use"
echo "generics/templates because they suck). Only concentrate on errors (if any)."
echo "========================================================================="

# Note the cd requires an absolute path for SRC, which is why we
# obtain the absolute path via $PWD above
for i in $dirs; do
 	cd "${SRC}/$i"
 	echo "Compiling: $i"
	./compile.sh
done

echo "======================================================================="
echo "Molly foundation classes were successfully compiled into: $COMPILED"
echo "You can now either:"
echo "  1) jar all of the compiled classes and put the jar in your classpath"
echo "  2) or more simply, put the [${COMPILED}] directory in your classpath"
echo 'Have fun !' [www.mollypages.org]
echo "======================================================================="

find "${SRC}" -name '*.class' | xargs $xargs_opt rm -f

