// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.lang.reflect.*;
import fc.util.*;

/** 
Extends the {@link java.io.BufferedReader#readLine readLine} functionality of {@link java.io.BufferedReader BufferedReader} by ignoring  any commented and empty lines.
<p>
<ul>
<li>comments start with <code>#</code> or <code>//</code></li>
<li>empty lines consist of only 0 or more whitespace</li>
</ul>
**/
public class CommentedFileReader extends BufferedReader
{
private static final boolean dbg = false;

/** 
Reads from the specified Reader

@throws IOException 	on error reading from the file
*/
public CommentedFileReader(Reader r) throws IOException
	{
	super(r);
	}
	
/** 
Reads from the specified file, using UTF-8 encoding.

@throws IOException 	on error reading from the file
*/
public CommentedFileReader(File f) throws IOException
	{
   	super(new InputStreamReader(new FileInputStream(f), "UTF-8"));
 	}	
 	
public String readLine() throws IOException
	{
	String line = super.readLine();
	
	while (shouldSkip(line)) {
		if (dbg) System.out.println("Skipping: " + line);
		line = super.readLine();
		}
		
	return line;
	}

protected boolean shouldSkip(String line)
	{
	//don't skip null, caller can then return null instead
	if (line == null) 
		return false;
		
	String trimline = line.trim();

	return trimline.length() == 0 
				|| trimline.startsWith("#") 
				|| trimline.startsWith("//");
	}

public static void main (String args[]) throws IOException
	{
	Args myargs = new Args(args);
	String filestr = myargs.getRequired("file");
	CommentedFileReader cr = new CommentedFileReader(new File(filestr));
	String line = null;
	while ((line = cr.readLine()) != null) {
		System.out.println(line);
		}
	}
}