// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io.fileselectors;

import java.io.*;
import java.util.*;

/**
Filters a list of files based on the specified prefix. Files <b>not</b>
having the specifed suffix are chosen. An empty string will result in all
files being rejected. Note, the <u>file name</u> not the entire path is
looked at by this filter. For example, if a file has a path of
<tt>/foo/bar/x.html</tt> then only <tt>x.html</tt> will be looked at by
this filter. (to retrieve the filename, this filter calls
<tt>getName()</tt> on the input file)
<p>
The specified pattern can be a single token or a a comma delimited set of 
tokens. For example:
<blockquote>
<pre>
.
foo
.,foo,bar
</pre>
</blockquote>
The above will reject all files starting with '.', reject files starting
with 'foo' and reject files starting with '.' or 'foo' or 'bar' respectively.

@author hursh jain
@date 	3/24/2002
**/	 	
public class FilePrefixRejectSelector extends ChainedFileSelector 
{
final static boolean dbg = false;
List matchlist;

public FilePrefixRejectSelector(String pattern) {
	this(pattern, null);
	}
	
public FilePrefixRejectSelector(String pattern, ChainedFileSelector filter) {
	super(filter);
	matchlist = new ArrayList();
	if (pattern.equals("")) { 
		matchlist.add("");
		}
	else {
		StringTokenizer tok = new StringTokenizer(pattern, ",");
		while ( tok.hasMoreTokens()) {
			matchlist.add(tok.nextToken());
			}
		}
	if (dbg) System.out.println("token match list=" + matchlist);
	}

protected boolean thisfilter(File name) 
	{	
	String filename = name.getName();
	
	if (dbg) System.out.print("FilePrefixRejectSelector: matching: " + filename);
	Iterator it = matchlist.listIterator(); 
	while (it.hasNext()) { 
		String pat = (String) it.next();
		if (dbg) System.out.println("; startsWith(" + pat + ")=" + filename.startsWith(pat));
		if (filename.startsWith(pat)) {
			return false;
			}
		}
	return true;
	}

public static void main(String[] args) throws Exception
	{
	new Test();
	}

/**
Unit Test History 	
<pre>
Class Version	Tester	Status		Notes
1.0				hj		passed	
</pre>
*/
static private class Test {
Test() throws Exception
	{
	File startdir = new File("/tmp");
	//will match both files and directories
	ChainedFileSelector sel = new FilePrefixRejectSelector(".");	
	File[] files = startdir.listFiles(sel);
	List list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);

	//empty suffix
	sel = new FilePrefixRejectSelector("");
	files = startdir.listFiles(sel);
	list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);
	}
}	//~class Test

}
